#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>

#include "base/defines.h"
#include "base/board.h"


FEField::FEField(QWidget *parent)
    : Field(parent)
{
    QWhatsThis::add(showRemoved,
                    i18n("Display the number of removed groups (\"puyos\")\n"
                         "classified by depth. '-' correponds to depth\n"
                         "higher than 3."));
    for (uint i=0; i<4; i++) {
        showRemoved->append(new LCD(6, showRemoved));
        showRemoved->lcd(i)->setLeadString(i==3 ? "-" : QString::number(i));
    }

    connect(board, SIGNAL(removedUpdated(uint, uint)),
            SLOT(removedUpdated(uint, uint)));
}

void FEField::removedUpdated(uint chain, uint removed)
{
    Q_ASSERT( chain<4 );
    showRemoved->lcd(chain)->showValue(removed);
    showRemoved->lcd(chain)->highlight();
}
