/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef MASTERCD_H
#define MASTERCD_H

#include <qwidget.h>
#include <kprocess.h>
#include <kconfig.h>
#include <mastercd_gui.h>

#include "imgprocout.h"
#include "processoutput.h"

/**
  *@author Kai Heitkamp
  */

class MasterCD : public MasterCD_GUI  {
   Q_OBJECT

public:
	MasterCD(QWidget *parent=0, const char *name=0);
	~MasterCD();

	QString cdrecord, mkisofs;

protected:
	int trackcount, tc;
	int MS_Start, MS_End, FS_Size;
	bool existsSession;
	ProcessOutput procoutdlg;
	ImgProcOut imgprocoutdlg;
	KProcess process;
	KProcess calcprocess;
	KShellProcess shellProcess;
	KConfig *config;

protected slots:
	void dragEnterEvent(QDragEnterEvent* event);
	void dropEvent(QDropEvent *event);
	void slot_quit();
	void slot_start();
	void abort_handler();
	void slot_TabWidget_add();
	void slot_setImageFile();
	void slot_setBootImage();
	void slot_imageType();
	void slot_toggleBootableCD();
	void slot_toggleWriteCD();
	void slot_toggleCreateImage();
	void slot_toggle_onthefly();
	void slot_multisession();
	void slot_makeImage();
	void slot_writeCD();
	void slot_writeCD_onthefly();
	void slot_deleteTrack();
	void slot_deleteAllTracks();
	void slot_calculateSize();
	void slot_calculateProcessExited(KProcess *);
	void slot_calculateRecStderr(KProcess *, char *, int);
	void slot_burnRecStderr(KProcess *, char *, int);
	void slot_burnProcessExited(KProcess *);
	void slot_makeImageStdout(KProcess *, char *, int);
	void slot_makeImageProcessExited(KProcess *);
	void slot_MSInfo();
	void slot_MSOutput( KProcess *, char *, int);
	void slot_MSInfoExited(KProcess *);
	void slot_PrintSize();
	void slot_PrintSizeOutput( KProcess *, char *, int);
	void slot_PrintSizeExited(KProcess *);
	void addItems( QString item, int tabIndex );
	void slot_TocInfo();
	void slot_TocInfoStdout( KProcess *, char *, int );
	void slot_TocInfoExited(KProcess *);
};

#endif
