/* This file is part of the KDE Project
 *
 * Copyright (C) 2001 Kurt Granroth <granroth@kde.org>
 *
 * This file is distributed under the BSD license. See the file "BSD"
 * in the subdirectory "licenses" of the package for the full license
 * text which has to be applied for this file.
 */
#ifndef KCMKXMLRPCD_H
#define KCMKXMLRPCD_H

#include <kcmodule.h>

class XmlRpcConfig;
class KAboutData;

class KXmlRpcModule : public KCModule
{
  Q_OBJECT

public:
  KXmlRpcModule(QWidget *parent = 0, const char *name=0);

  void load();
  void save();
  void defaults();

  QString quickHelp() const;
  const KAboutData* aboutData() const;

protected slots:
  void configChanged();

protected:
  XmlRpcConfig *ui;
};
#endif // KCMKXMLRPCD_H
