.TH sane-v4l 5 "15 July 2000"
.IX sane-v4l
.SH NAME
sane-v4l - SANE interface for Video for Linux API
.SH DESCRIPTION
The
.B sane-v4l
library implements a SANE (Scanner Access Now Easy) backend that
provides generic access to video cameras and similar equipment using
the V4L (Video for Linux) API.
.PP

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
v4l device.  The special device name must be a v4l device or a symlink
to such a device.  For example, such a device name could be
.I /dev/video0
or
.IR /dev/bttv0 .
.SH CONFIGURATION
The contents of the
.I v4l.conf
file is a list of device names that correspond to v4l
devices.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/bttv0
.br
# this is a comment
.br
/dev/video3
.RE
.SH FILES
.TP
.I @CONFIGDIR@/v4l.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-v4l.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-v4l.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_V4L
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.
.SH AUTHOR
Juergen G. Schimmer
.PP
Man page copied from the pint backend and edited by Henning 
Meier-Geinitz.

.SH BUGS:
If more than one video card is present, a crash may occur.
.br
Send bug reports to the SANE mailing list: sane-devel@mostang.com.  You must
be subscribed to the list to send mail. See
http://www.mostang.com/sane/mail.html for details.

.SH SEE ALSO
sane(7).
