#ifndef _PREFS_H
#define _PREFS_H 1

#include <gnome.h>

struct preferences {
	gchar mycall[64];
	gchar myname[64];
	gchar myqth[64];
	gchar myloc[64];
	gchar myemail[64];

	GdkColor rx_color;
	GdkColor tx_color;
	GdkColor hl_color;
	GdkColor rx_win_color;
	GdkColor tx_win_color;

	gchar rx_font[256];
	gchar tx_font[256];

	gfloat txoffset;

	gboolean afc;
	gboolean squelch;

	gfloat sqval;

	gchar sounddev[64];
	gboolean eightbitsound;
	gboolean fullduplexsound;
	gboolean testmode;

	gchar pttdev[64];
	gboolean pttinv;

	gfloat sensitivity;
	gint window;

	gfloat rttyshift;
	gfloat rttybaud;
	gint rttybits;
	gint rttyparity;
	gint rttystop;
	gboolean rttyreverse;
	gboolean rttymsb;

	gchar qsobands[256];

	gchar timefmt[64];
	gchar datefmt[64];
};

extern struct preferences prefs;
extern struct preferences tmp_prefs;

extern void apply_config(GtkWidget *);
extern void load_config(void);
extern void fill_config(GtkWidget *);

extern GdkFont *rxfont, *txfont;

#endif
