#ifndef _THROB_H
#define _THROB_H

#include "cmplx.h"
#include "trx.h"

#define	SampleRate	8000
#define	DownSample	32

#define	NumTones	9
#define	NumChars	45

#define	SymbolLen1	8192
#define	SymbolLen2	4096
#define	SymbolLen4	2048

#define	FilterFFTLen	8192
#define	PipeLen		(2*SymbolLen1/DownSample)

struct throb {
	/*
	 * Common stuff
	 */
	int symlen;
	double phaseacc;
	double freqs[NumTones];

	/*
	 * RX related stuff
	 */
	struct filter *hilbert;
	struct fftfilt *fftfilt;

	complex *rxtone[NumTones];

	complex *tonelo[NumTones];
	complex *tonehi[NumTones];

	complex pipe[PipeLen];
	unsigned int pipeptr;

	int shift;

	/*
	 * TX related stuff
	 */
	int preamble;
	double *txpulse;
};

/* in throb.c */
extern void throb_init(struct trx *trx);

/* in throbrx.c */
extern int throb_rxprocess(struct trx *trx, float *buf, int len);

/* in throbtx.c */
extern int throb_txprocess(struct trx *trx);

#endif
