/*
 * xconvers - GTK+ convers client for amateur radio
 * Copyright (C) 2000-2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * utils.c - private functions that don't belong in other modules
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include "support.h"
#include "types.h"
#include "color.h"
#include "net.h"
#include "../pixmaps/xconvers.xpm"

extern GtkWidget *mainwindow;
extern preferencestype preferences;

/*
 * Lookup a widget and set visible or invisible, depending on 'state'.
 */

void widget_visible(gchar *name, gboolean state)
{
  GtkWidget *widget;
  
  widget = lookup_widget(mainwindow, name);
  if (state) gtk_widget_show(widget); else gtk_widget_hide(widget);
}

/*
 * Needed by g_hash_table_foreach_remove, to free every key in the hash table.
 */

gboolean remove_calls(gchar *key, gpointer value, gpointer user_data)
{
  g_free(key);
  return(TRUE);
}

/*
 * Set the icon and icon name of a dialog.
 */

void set_icon(GtkWidget *dialog, gchar *name)
{
  GtkStyle *dialogstyle;
  GdkBitmap *bitmap;
  GdkPixmap *icon;

  gtk_widget_realize(dialog);
  dialogstyle = gtk_widget_get_style(dialog);
  icon = gdk_pixmap_create_from_xpm_d(dialog->window, &bitmap, &dialogstyle->bg[GTK_STATE_NORMAL], xconvers_xpm);
  gdk_window_set_icon(dialog->window, NULL, icon, bitmap);
  gdk_window_set_icon_name(dialog->window, name);
}

/*
 * Set title of a dialog.
 */
void set_title(GtkWidget *dialog, gchar *format)
{
  GString *title = g_string_new("");
  
  g_string_sprintf(title, format, PACKAGE);
  gtk_window_set_title (GTK_WINDOW(dialog), title->str);
  g_string_free(title, TRUE);
}

/*
 * Print a message to the statusbar. If the bar is disabled just print to the
 * main window, prepended by an arrow.
 */
void updatestatusbar(GString *statusmessage)
{
  GtkWidget *mainstatusbar;

  mainstatusbar = lookup_widget (mainwindow, "mainstatusbar");
  gtk_statusbar_pop (GTK_STATUSBAR (mainstatusbar), 1);
  gtk_statusbar_push (GTK_STATUSBAR (mainstatusbar), 1, statusmessage->str);
  if (!preferences.statusbar)
  {
    g_string_prepend(statusmessage, "--> ");
    g_string_append(statusmessage, "\n");
    maintext_add(statusmessage->str, MESSAGE_TX);
  }
}