// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSCONSOLEWIDGET_H
#define KJSEMBEDJSCONSOLEWIDGET_H

#include <qframe.h>
#include <kjs/object.h>

namespace KJS { class Interpreter; }

class QComboBox;
class QPushButton;

namespace KJSEmbed {

class MessageLogWidget;

/**
 * A QWidget that provides a console for executing Javascript commands. Creating
 * a JS console is easy, as you can see below:
 *
 * <pre>
 *   KJS::Object global( new KJS::ObjectImp() );
 *   KJS::Interpreter *js = new KJS::Interpreter( global );
 *   KJSEmbed::JSConsoleWidget *win = new KJSEmbed::JSConsoleWidget( js );
 *   win->addBindings( js->globalExec(), global );
 * </pre>
 *
 * This example creates a console for a JS interpreter and adds a print function
 * to the interpreter.
 *
 * @version $Id: jsconsolewidget.h,v 1.3.2.1 2003/05/19 14:59:35 mueller Exp $
 * @author Richard Moore, rich@kde.org
 */
class JSConsoleWidget : public QFrame
{
    Q_OBJECT

public:
    JSConsoleWidget( QWidget *parent=0, const char *name=0 );
    JSConsoleWidget( KJS::Interpreter *js, QWidget *parent=0, const char *name=0 );
    ~JSConsoleWidget();

    KJS::Interpreter *jscript() const { return js; }
    MessageLogWidget *messages() const { return log; }

    void addBindings( KJS::ExecState *state, KJS::Object &object );

public slots:
    void execute();
    bool execute( const QString &cmd );

protected:
    void createView();

    /**
     * @internal
     * Provides the implementation of a JS method.
     */
    class MethodImp : public KJS::ObjectImp
    {
    public:
	enum MethodId { MethodPrint };

	MethodImp( MethodId mid, JSConsoleWidget *parent )
	    : KJS::ObjectImp(), id(mid), w(parent) {}
	~MethodImp() {}

	/** 
	 * Reimplemented to specify that we implement the call operation.
	 */
	virtual bool implementsCall() const { return true; }

	virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self,
				 const KJS::List &args );

    private:
	MethodId id;
	JSConsoleWidget *w;
	class Private *d;
    };

private:
    MessageLogWidget *log;
    QComboBox *cmd;
    QPushButton *run;

    KJS::Interpreter *js;
    class Private *d;
};

} // namespace KJSEmbed

#endif // KJSEMBEDJSCONSOLEWIDGET_H

// Local Variables:
// c-basic-offset: 4
// End:
