/***************************************************************************
                          pybrowsenode.h  -  description
                             -------------------
    begin                : Mon Aug 27 2001
    copyright            : (C) 2001 by Christian Bird
    email                : chrisb@lineo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PYBROWSENODE_H
#define PYBROWSENODE_H

#include <qlistview.h>
#include <qpixmap.h>

#define PYCLASS 1
#define PYMETHOD 2
#define PYFUNCTION 3
#define PYVARIABLE 4
#define PYOTHER 5

/**
  *@author Christian Bird
  */



class PyBrowseNode : public QListViewItem  {
public:
	QPixmap *pyClassPixmap;
	
    PyBrowseNode(QListView *parent, QString a_name, QString a_signature, int type);
	PyBrowseNode(QListViewItem *parent, QString a_name, QString a_signature, int type);
	~PyBrowseNode();
    
    void init(QString a_name, QString a_signature, int nodeType);
    
    void setName(QString name);
	QString getName();
    void setLine(int line);
    int getLine();
    void setSig(QString signature);
	QString getSig();
    void setType(int type);
    int getType();
    void setClass(QString a_method_class);
    QString getClass();
    
    QString getQualifiedName();
    
private:
	QString name;
    QString signature;
    QString node_class;
	int line;
	int node_type;

};

#endif
