// -*- c++ -*-

#ifndef KSYSTRAYCMD_H
#define KSYSTRAYCMD_H

#include <qlabel.h>
#include <kwin.h>

class KShellProcess;
class KWinModule;

/**
 * Provides a system tray icon for a normal window.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: ksystraycmd.h,v 1.4.2.1 2003/05/21 14:55:15 lunakl Exp $
 */
class KSysTrayCmd : public QLabel
{
  Q_OBJECT
public:
  KSysTrayCmd();
  ~KSysTrayCmd();

  void setWindow( WId w ) { win = w; }
  void setCommand( const QString &cmd ) { command = cmd; }
  void setPattern( const QString &regexp ) { window = regexp; }
  void setStartOnShow( bool enable ) { lazyStart = enable; }
  void setNoQuit( bool enable ) { noquit = enable; }
  void setQuitOnHide( bool enable ) { quitOnHide = enable; }
  void setDefaultTip( const QString &tip ) { tooltip = tip; }
  bool hasTargetWindow() const { return (win != 0); }
  bool hasRunningClient() const { return (client != 0); }
  const QString &errorMsg() const { return errStr; }

  bool start();

public slots:
  void refresh();

  void showWindow();
  void hideWindow();
  void toggleWindow() { if ( isVisible ) hideWindow(); else showWindow(); }

  void setTargetWindow( WId w );
  void execContextMenu( const QPoint &pos );

  void quit();
  void quitClient();

protected slots:
  void clientExited();

  void windowAdded(WId w);
  void windowChanged(WId w);

protected:
  bool startClient();
  void checkExistingWindows();
  void setTargetWindow( const KWin::Info &info );

  void mousePressEvent( QMouseEvent *e );
#if QT_VERSION < 0x030200
  void enterEvent( QEvent* );
#endif

private:
  QString command;
  QString window;
  QString tooltip;
  bool isVisible;
  bool lazyStart;
  bool noquit;
  bool quitOnHide;

  WId win;
  KShellProcess *client;
  KWinModule *kwinmodule;
  QString errStr;
};

#endif // KSYSTRAYCMD_H
