/***************************************************************************
                            kde_KFileDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILEDIALOG
#define KDE_KFILEDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Provides a user (and developer) friendly way to
 select files and directories.

 The widget can be used as a drop in replacement for the
 @ref  QFileDialog widget, but has greater functionality and a nicer GUI.

 You will usually want to use one of the static methods
 @ref getOpenFileName(), @ref getSaveFileName(), @ref getOpenURL()
 or for multiple files @ref getOpenFileNames() or @ref getOpenURLs().

 The dialog has been designed to allow applications to customise it
 by subclassing. It uses geometry management to ensure that subclasses
 can easily add children that will be incorporated into the layout.

 \image html kfiledialog.png "KDE File Dialog"

 @author Richard J. Moore <rich@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A file selection dialog.

*/
#define KFILEDIALOG_Other	0
#define KFILEDIALOG_Opening	0
#define KFILEDIALOG_Saving	1

/** *
 Constructs a file dialog.

*/
kde_KFileDialog * kde_new_KFileDialog(qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, char* name, int modal);

/** *
 Constructs a file dialog.

 The parameters here are identical to the first constructor except
 for the addition of a QWidget parameter.

 Historical note: The original version of KFileDialog did not have this extra
 parameter. It was added later, and, in order to maintain binary compatibility,
 it was placed in a new constructor instead of added to the original one.

*/
kde_KFileDialog * kde_new_KFileDialog1(qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, char* name, int modal, qt_QWidget * widget);

/** *
 Destructs the file dialog.
     
*/
void kde_del_KFileDialog( kde_KFileDialog* p );

/** *

*/
kde_KURL* kde_KFileDialog_selectedURL(kde_KFileDialog* instPointer);

/** *

*/
kde_KURLList* kde_KFileDialog_selectedURLs(kde_KFileDialog* instPointer);

/** *

*/
kde_KURL* kde_KFileDialog_baseURL(kde_KFileDialog* instPointer);

/** *
 Returns the full path of the selected file in the local filesystem.
 (Local files only)
     
*/
qt_QString * kde_KFileDialog_selectedFile(kde_KFileDialog* instPointer);

/** *
 Returns a list of all selected local files.
     
*/
qt_QStringList* kde_KFileDialog_selectedFiles(kde_KFileDialog* instPointer);

/** *
 Sets the directory to view.

*/
void kde_KFileDialog_setURL(kde_KFileDialog* instPointer,kde_KURL* url, int clearforward);

/** *
 Sets the file name to preselect to @p name

 This takes absolute URLs and relative file names.
     
*/
void kde_KFileDialog_setSelection(kde_KFileDialog* instPointer,qt_QString * name);

/** *
 Sets the operational mode of the filedialog to @p Saving, @p Opening
 or @p Other. This will set some flags that are specific to loading
 or saving files. E.g. @ref setKeepLocation() makes mostly sense for
 a save-as dialog. So setOperationMode( KFileDialog::Saving ); sets
 setKeepLocation for example.

 The mode @p Saving, together with a default filter set via
 @ref setMimeFilter() will make the filter combobox read-only.

 The default mode is @p Opening.

 Call this method right after instantiating KFileDialog.

*/
void kde_KFileDialog_setOperationMode(kde_KFileDialog* instPointer,int arg1);

/** *

*/
int kde_KFileDialog_operationMode(kde_KFileDialog* instPointer);

/** *
 Sets whether the filename/url should be kept when changing directories.
 This is for example useful when having a predefined filename where
 the full path for that file is searched.

 This is implicitly set when @ref operationMode() is KFileDialog::Saving

 getSaveFileName() and getSaveURL() set this to true by default, so that
 you can type in the filename and change the directory without having
 to type the name again.
     
*/
void kde_KFileDialog_setKeepLocation(kde_KFileDialog* instPointer,int keep);

/** *

*/
int kde_KFileDialog_keepsLocation(kde_KFileDialog* instPointer);

/** *
 Sets the filter to be used to @p filter.

 You can set more
 filters for the user to select seperated by '\n'. Every
 filter entry is defined through namefilter|text to diplay.
 If no | is found in the expression, just the namefilter is
 shown. Examples:

 <code>
 kfile->setFilter("*.cpp|C++ Source Files\n*.h|Header files");
 kfile->setFilter("*.cpp");
 kfile->setFilter("*.cpp|Sources (*.cpp)");
 kfile->setFilter("*.cpp *.cc *.C|C++ Source Files\n*.h *.H|Header files");
 </code>

 Note: The text to display is not parsed in any way. So, if you
 want to show the suffix to select by a specific filter, you must
 repeat it.

 If the filter contains a '/', a mimetype-filter is assumed. You can
 specify multiple mimetypes like this (separated with space):

 <code>
 kfile->setFilter( "image/png text/html text/plain" );
 </code>

*/
void kde_KFileDialog_setFilter(kde_KFileDialog* instPointer,qt_QString * filter);

/** *
 Returns the current filter as entered by the user or one of the
 predefined set via @ref setFilter().

*/
qt_QString * kde_KFileDialog_currentFilter(kde_KFileDialog* instPointer);

/** *
 Sets the filter up to specify the output type.

 Do not use in conjunction with @ref setFilter()

     
*/
//void kde_KFileDialog_setFilterMimeType(kde_KFileDialog* instPointer,qt_QString * label, kde_KMimeType_List* types, kde_KMimeType_Ptr* defaultType);

/** *
 Returns the mimetype for the desired output format.

 This is only valid if @ref setFilterMimeType() has been called
 previously.

*/
//kde_KMimeType_Ptr kde_KFileDialog_currentFilterMimeType(kde_KFileDialog* instPointer);

/** *
 Sets the filter up to specify the output type.

 Do not use in conjunction with @ref setFilter()
     
*/
void kde_KFileDialog_setMimeFilter(kde_KFileDialog* instPointer,qt_QStringList* types, qt_QString * defaultType);

/** *
 The mimetype for the desired output format.

 This is only valid if @ref setMimeFilter() has been called
 previously.

*/
qt_QString * kde_KFileDialog_currentMimeFilter(kde_KFileDialog* instPointer);

/** *
  Clears any mime- or namefilter. Does not reload the directory.
     
*/
void kde_KFileDialog_clearFilter(kde_KFileDialog* instPointer);

/** *

 Add a preview widget and enter the preview mode.

 In this mode
 the dialog is split and the right part contains your widget.
 This widget has to inherit @ref QWidget and it has to implement
 a slot @ref showPreview(const KURL &); which is called
 every time the file changes. You may want to look at
 koffice/lib/kofficecore/koFilterManager.cc for some hints :)

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.
     
*/
void kde_KFileDialog_setPreviewWidget(kde_KFileDialog* instPointer,qt_QWidget * w);

/** *
 Adds a preview widget and enters the preview mode.

 In this mode the dialog is split and the right part contains your
 preview widget.

 Ownership is transferred to KFileDialog. You need to create the
 preview-widget with "new", i.e. on the heap.

*/
void kde_KFileDialog_setPreviewWidget1(kde_KFileDialog* instPointer,kde_KPreviewWidgetBase* w);

/** *

     
*/
void kde_KFileDialog_setMode(kde_KFileDialog* instPointer,int m);

/** *
 Sets the mode of the dialog.

 The mode is defined as (in kfile.h):
 <code>
    enum Mode {
         File         = 1,
         Directory    = 2,
         Files        = 4,
         ExistingOnly = 8,
         LocalOnly    = 16
    };
 </code>
 You can OR the values, e.g.
 <code>
 KFile::Mode mode = static_cast<KFile::Mode>( KFile::Files |
                                              KFile::ExistingOnly |
                                              KFile::LocalOnly );
 setMode( mode );
 </code>
     
*/
void kde_KFileDialog_setMode1(kde_KFileDialog* instPointer,unsigned int m);

/** *
 Returns the mode of the filedialog.

*/
int kde_KFileDialog_mode(kde_KFileDialog* instPointer);

/** *
 Sets the text to be displayed in front of the selection.

 The default is "Location".
 Most useful if you want to make clear what
 the location is used for.
     
*/
void kde_KFileDialog_setLocationLabel(kde_KFileDialog* instPointer,qt_QString * text);

/** *
 Returns a pointer to the toolbar.

 You can use this to insert custom
 items into it, e.g.:
 <code>
      yourAction = new KAction( i18n("Your Action"), 0,
                                this, SLOT( yourSlot() ),
                                this, "action name" );
      yourAction->plug( kfileDialog->toolBar() );
 </code>
     
*/
kde_KToolBar* kde_KFileDialog_toolBar(kde_KFileDialog* instPointer);

/** *

*/
kde_KPushButton* kde_KFileDialog_okButton(kde_KFileDialog* instPointer);

/** *

*/
kde_KPushButton* kde_KFileDialog_cancelButton(kde_KFileDialog* instPointer);

/** *

*/
kde_KActionCollection* kde_KFileDialog_actionCollection(kde_KFileDialog* instPointer);

/** *

*/
int kde_KFileDialog_pathComboIndex(kde_KFileDialog* instPointer);

/** *
 Creates a modal file dialog and return the selected
 filename or an empty string if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
qt_QString * kde_KFileDialog_getOpenFileName( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 filenames or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
qt_QStringList* kde_KFileDialog_getOpenFileNames( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 URL or an empty string if none was chosen.

 Note that with
 this method the user must select an existing URL.

*/
kde_KURL* kde_KFileDialog_getOpenURL( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 URLs or an empty list if none was chosen.

 Note that with
 this method the user must select an existing filename.

*/
kde_KURLList* kde_KFileDialog_getOpenURLs( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
qt_QString * kde_KFileDialog_getSaveFileName( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 filename or an empty string if none was chosen.

 Note that with this
 method the user need not select an existing filename.

*/
kde_KURL* kde_KFileDialog_getSaveURL( qt_QString * startDir, qt_QString * filter, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 directory or an empty string if none was chosen.

*/
qt_QString * kde_KFileDialog_getExistingDirectory( qt_QString * startDir, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog and returns the selected
 directory or an empty string if none was chosen.

 Contrary to @ref getExistingDirectory(), this method allows the
 selection of a remote directory.

*/
kde_KURL* kde_KFileDialog_getExistingURL( qt_QString * startDir, qt_QWidget * parent, qt_QString * caption);

/** *
 Creates a modal file dialog with an image previewer and returns the
 selected url or an empty string if none was chosen.

*/
kde_KURL* kde_KFileDialog_getImageOpenURL( qt_QString * startDir, qt_QWidget * parent, qt_QString * caption);

/** *
 adds a entry of the current directory. If disableUpdating is set
 to true, it will care about clever updating

*/
//void kde_KFileDialog_addDirEntry(kde_KFileDialog* instPointer,kde_KFileItem* entry, int disableUpdating);

/** *
 Perform basic initialization tasks. Called by constructors.

*/
void kde_KFileDialog_init(kde_KFileDialog* instPointer,qt_QString * startDir, qt_QString * filter, qt_QWidget * widget);

/** *
 rebuild geometry managment.

      
*/
void kde_KFileDialog_initGUI(kde_KFileDialog* instPointer);

/** *
 called when an item is highlighted/selected in multiselection mode.
 handles setting the locationEdit.
     
*/
void kde_KFileDialog_multiSelectionChanged(kde_KFileDialog* instPointer);

/** *
 Reads configuration and applies it (size, recent directories, ...)
     
*/
void kde_KFileDialog_readConfig(kde_KFileDialog* instPointer,kde_KConfig* arg1, qt_QString * group);

/** *
 Saves the current configuration
     
*/
void kde_KFileDialog_writeConfig(kde_KFileDialog* instPointer,kde_KConfig* arg1, qt_QString * group);

/** *
 Reads the recent used files and inserts them into the location combobox
     
*/
void kde_KFileDialog_readRecentFiles(kde_KFileDialog* instPointer,kde_KConfig* arg1);

/** *
 Saves the entries from the location combobox.
     
*/
void kde_KFileDialog_saveRecentFiles(kde_KFileDialog* instPointer,kde_KConfig* arg1);

/** *
 Parses the string "line" for files. If line doesn't contain any ", the
 whole line will be interpreted as one file. If the number of " is odd,
 an empty list will be returned. Otherwise, all items enclosed in " "
 will be returned as correct urls.
     
*/
kde_KURLList* kde_KFileDialog_tokenize(kde_KFileDialog* instPointer,qt_QString * line);
kde_KURLList* kde_KFileDialog_parseSelectedURLs(kde_KFileDialog* instPointer);
void kde_KFileDialog_virtual_hook(kde_KFileDialog* instPointer,int identifier, void* data);
void kde_KFileDialog_urlEntered(kde_KFileDialog* instPointer,kde_KURL* arg1);
void kde_KFileDialog_enterURL(kde_KFileDialog* instPointer,kde_KURL* url);
void kde_KFileDialog_enterURL1(kde_KFileDialog* instPointer,qt_QString * url);
void kde_KFileDialog_locationActivated(kde_KFileDialog* instPointer,qt_QString * url);

/** *

     
*/
void kde_KFileDialog_toolbarCallback(kde_KFileDialog* instPointer,int arg1);
void kde_KFileDialog_slotFilterChanged(kde_KFileDialog* instPointer);
void kde_KFileDialog_pathComboChanged(kde_KFileDialog* instPointer,qt_QString * arg1);
void kde_KFileDialog_fileHighlighted1(kde_KFileDialog* instPointer,kde_KFileItem* i);
void kde_KFileDialog_fileSelected1(kde_KFileDialog* instPointer,kde_KFileItem* i);
void kde_KFileDialog_slotStatResult(kde_KFileDialog* instPointer,kde_Job* job);
void kde_KFileDialog_slotLoadingFinished(kde_KFileDialog* instPointer);
void kde_KFileDialog_dirCompletion(kde_KFileDialog* instPointer,qt_QString * arg1);
void kde_KFileDialog_fileCompletion(kde_KFileDialog* instPointer,qt_QString * arg1);

/** *

*/
void kde_KFileDialog_toggleSpeedbar(kde_KFileDialog* instPointer,int arg1);

/** *

     
*/
void kde_KFileDialog_updateStatusLine(kde_KFileDialog* instPointer,int dirs, int files);
void kde_KFileDialog_slotOk(kde_KFileDialog* instPointer);
void kde_KFileDialog_accept(kde_KFileDialog* instPointer);
void kde_KFileDialog_slotCancel(kde_KFileDialog* instPointer);
void kde_KFileDialog_addToRecentDocuments(kde_KFileDialog* instPointer);
void kde_KFileDialog_initSpeedbar(kde_KFileDialog* instPointer);

#endif
