/***************************************************************************
                            kde_KIconLoader.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONLOADER
#define KDE_KICONLOADER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Iconloader for KDE.

 KIconLoader will load the current icon theme and all its base themes.
 Icons will be searched in any of these themes. Additionally, it caches
 icons and applies effects according the the user's preferences.

 In KDE, it is encouraged to load icons by "Group". An icon group is a
 location on the screen where icons are being used. Standard groups are:
 Desktop, Toolbar, MainToolbar, Small and Panel. Each group has some
 centrally configured properties bound to it, including the icon size
 and effects. This makes it possible to offer a consistent icon look in
 all KDE applications.

 The standard groups are defined below.

 The icons are stored on disk in an icon theme or in a standalone
 directory. The icon theme directories contain multiple sizes and/or
 depths for the same icon. The iconloader will load the correct one based
 on the icon group and the current theme. Icon themes are stored globally
 in share/icons, or, application specific in share/apps/$appdir/icons.

 The standalone directories contain just one version of an icon. The
 directories that are searched are: $appdir/pics and $appdir/toolbar.
 Icons in these directories can be loaded by using the special group
 "User".

 
 @short *
 Iconloader for KDE.
*/

/** *
 Constructs an iconloader.

*/
kde_KIconLoader * kde_new_KIconLoader(qt_QString * appname, kde_KStandardDirs* dirs);

/** *
 Cleanup
     
*/
void kde_del_KIconLoader( kde_KIconLoader* p );

/** *
 Adds @p appname to the list of application specific directories.

*/
void kde_KIconLoader_addAppDir(kde_KIconLoader* instPointer,qt_QString * appname);

/** *
 Loads an icon. It will try very hard to find an icon which is
 suitable. If no exact match is found, a close match is searched.
 If neither an exact nor a close match is found, a null pixmap or
 the "unknown" pixmap is returned, depending on the value of the
 @p canReturnNull parameter.

*/
qt_QPixmap * kde_KIconLoader_loadIcon(kde_KIconLoader* instPointer,qt_QString * name, int group, int size, int state, qt_QString* path_store, int canReturnNull);

/** *
 Creates an icon set, that will do on-demand loading of the icon.
 Loading itself is done by calling @ref loadIcon .

*/
qt_QIconSet* kde_KIconLoader_loadIconSet(kde_KIconLoader* instPointer,qt_QString * name, int group, int size, int canReturnNull);

/** *
 Creates an icon set, that will do on-demand loading of the icon.
 Loading itself is done by calling @ref loadIcon .

*/
qt_QIconSet* kde_KIconLoader_loadIconSet1(kde_KIconLoader* instPointer,qt_QString * name, int group, int size);

/** *
 Returns the path of an icon.

*/
qt_QString * kde_KIconLoader_iconPath(kde_KIconLoader* instPointer,qt_QString * name, int group_or_size, int canReturnNull);

/** *
 Loads an animated icon.

*/
//QMovie kde_KIconLoader_loadMovie(kde_KIconLoader* instPointer,qt_QString * name, int group, int size);

/** *
 Returns the path to an animated icon.

*/
qt_QString * kde_KIconLoader_moviePath(kde_KIconLoader* instPointer,qt_QString * name, int group, int size);

/** *
 Loads an animated icon. In the future, this will be replaced by a
 routine which loads an MNG animation and returns a QMovie.

*/
qt_QStringList* kde_KIconLoader_loadAnimated(kde_KIconLoader* instPointer,qt_QString * name, int group, int size);

/** *
 Queries all available icons for a specific group, having a specific
 context.

*/
qt_QStringList* kde_KIconLoader_queryIcons(kde_KIconLoader* instPointer,int group_or_size, int context);

/** *
 Queries all available icons for a specific context.

*/
qt_QStringList* kde_KIconLoader_queryIconsByContext(kde_KIconLoader* instPointer,int group_or_size, int context);

/** *
 Returns a list of all icons (*.png or *.xpm extension) in the
 given directory.

*/
qt_QStringList* kde_KIconLoader_queryIconsByDir(kde_KIconLoader* instPointer,qt_QString * iconsDir);

/** *
 Returns the current size of the group.

*/
int kde_KIconLoader_currentSize(kde_KIconLoader* instPointer,int group);

/** *
 Returns a pointer to the current theme. Can be used to query
 available and default sizes for groups.

*/
kde_KIconTheme* kde_KIconLoader_theme(kde_KIconLoader* instPointer);

/** *
 Returns a pointer to the KIconEffect object used by the icon loader.

*/
kde_KIconEffect* kde_KIconLoader_iconEffect(kde_KIconLoader* instPointer);

/** *
 Called by KInstance::newIconLoader to reconfigure the icon loader.

*/
void kde_KIconLoader_reconfigure(kde_KIconLoader* instPointer,qt_QString * _appname, kde_KStandardDirs* _dirs);

/** *
 Returns if the user wants to use blend the icons with the background
  using the alpha channel information for a given group.

*/
int kde_KIconLoader_alphaBlending(kde_KIconLoader* instPointer,int group);

/** *
 Returns the unknown icon. An icon that is used when no other icon
 can be found.

*/
qt_QPixmap * kde_KIconLoader_unknown( );

#endif
