package org.kde.koala;
import org.kde.qt.*;


/** {@link CopyJob} emits these signals */
public interface CopyJobSignals {

/** 
 The user chose to rename 'from' to 'to'
         
*/
	void renamed( Job arg1, KURL from, KURL to );

/** 
 Emitted when the slave successfully connected to the host.
 There is no guarantee the slave will send this, and this is
 currently unused (in the applications).
         
*/
	void connected( Job arg1 );
	void processedDirs( Job arg1, long dirs );

/** 
 Emitted to display information about the speed of this job.
         
*/
	void speed( Job arg1, long bytes_per_second );

/** 
 Emitted when the job is finished, in any case (completed, canceled,
 failed...). Use {@link CopyJob#error} to know the result.
         
*/
	void result( Job job );

/** 
 Regularly emitted to show the progress of this job
 (current data size for transfers, entries listed).
         
*/
	void processedSize( Job arg1, int size );

/** 
 The job emits this signal when copying or moving a file or directory successfully finished.

*/
	void copyingDone( Job arg1, KURL from, KURL to, boolean directory, boolean renamed );
	void totalFiles( Job arg1, long files );

/** 
 The job is creating the directory <code>dir</code>
         
*/
	void creatingDir( Job arg1, KURL dir );

/** 
 Emitted to display information about this job, as sent by the slave.
 Examples of message are "Resolving host", "Connecting to host...", etc.
         
*/
	void infoMessage( Job arg1, String msg );
	void processedFiles( Job arg1, long files );

/** 
 The job is copying or moving a symbolic link, that points to target.
 The new link is created in <code>to.</code> The existing one is/was in <code>from.</code>
 This signal is mainly for the Undo feature.
         
*/
	void copyingLinkDone( Job arg1, KURL from, String target, KURL to );
	void destroyed( QObject obj );

/** 
 The job is moving a file or directory
         
*/
	void moving( Job arg1, KURL from, KURL to );

/** 
 Emitted when the job is canceled.

 Signal <code>result</code> is emitted as well, and error() is,
 in this case, ERR_USER_CANCELED.
         
*/
	void canceled( Job job );

/** 
 The job is creating a symbolic link
         
*/
	void linking( Job arg1, String target, KURL to );
	void totalDirs( Job arg1, long dirs );

/** 
 Progress signal showing the overall progress of the job
 This is valid for any kind of job, and allows using a
 a progress bar very easily. (see {@link KProgress}).
 Note that this signal is not emitted for finished jobs
 (i.e. percent is never 100).
         
*/
	void percent( Job job, long percent );

/** 
 Emitted when we know the size of this job (data size for transfers,
 number of entries for listings).
         
*/
	void totalSize( Job arg1, int size );

/** 
 The job is copying a file or directory
         
*/
	void copying( Job arg1, KURL from, KURL to );
}

