package org.kde.koala;
import org.kde.qt.*;


/** {@link DeleteJob} emits these signals */
public interface DeleteJobSignals {

/** 
 Emitted when the slave successfully connected to the host.
 There is no guarantee the slave will send this, and this is
 currently unused (in the applications).
         
*/
	void connected( Job arg1 );
	void processedDirs( Job arg1, long dirs );

/** 
 Emitted to display information about the speed of this job.
         
*/
	void speed( Job arg1, long bytes_per_second );

/** 
 Emitted when the job is finished, in any case (completed, canceled,
 failed...). Use {@link DeleteJob#error} to know the result.
         
*/
	void result( Job job );

/** 
 Regularly emitted to show the progress of this job
 (current data size for transfers, entries listed).
         
*/
	void processedSize( Job arg1, int size );
	void totalFiles( Job arg1, long files );

/** 
 Emitted to display information about this job, as sent by the slave.
 Examples of message are "Resolving host", "Connecting to host...", etc.
         
*/
	void infoMessage( Job arg1, String msg );
	void processedFiles( Job arg1, long files );
	void destroyed( QObject obj );

/** 
 Emitted when the job is canceled.

 Signal <code>result</code> is emitted as well, and error() is,
 in this case, ERR_USER_CANCELED.
         
*/
	void canceled( Job job );
	void deleting( Job arg1, KURL file );
	void totalDirs( Job arg1, long dirs );

/** 
 Progress signal showing the overall progress of the job
 This is valid for any kind of job, and allows using a
 a progress bar very easily. (see {@link KProgress}).
 Note that this signal is not emitted for finished jobs
 (i.e. percent is never 100).
         
*/
	void percent( Job job, long percent );

/** 
 Emitted when we know the size of this job (data size for transfers,
 number of entries for listings).
         
*/
	void totalSize( Job arg1, int size );
}

