/***************************************************************************
                            KBugReport.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A dialog box for sending bug reports.
 All the information needed by the dialog box
 (program name, version, bug-report address, etc.)
 comes from the {@link KAboutData} class.
 Make sure you create an instance of KAboutData and pass it
 to {@link KCmdLineArgs}.

 See {@link KBugReportSignals} for signals emitted by KBugReport.

 

 @author David Faure <faure@kde.org>
 
 @short A dialog box for sending bug reports.

*/
public class KBugReport extends KDialogBase  {
	protected KBugReport(Class dummy){super((Class) null);}

	private native void newKBugReport( QWidget parent, boolean modal, KAboutData aboutData);

/** 
 Creates a bug-report dialog.
 Note that you shouldn't have to do this manually,
 since {@link KHelpMenu} takes care of the menu item
 for "Report Bug..." and of creating a KBugReport dialog.
   
*/
	public KBugReport( QWidget parent, boolean modal, KAboutData aboutData) {
		super((Class) null);
		newKBugReport( parent, modal, aboutData);
	}
	private native void newKBugReport();
	public KBugReport() {
		super((Class) null);
		newKBugReport();
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	protected native String text();
	protected native boolean sendBugReport();
	protected native void virtual_hook( int identifier, int data);

/** 
 "Configure email" has been clicked - this calls kcmshell System/email
   
*/
	protected native void slotConfigureEmail();

/** 
 Sets the "From" field from the e-mail configuration
 Called at creation time, but also after "Configure email" is closed.
   
*/
	protected native void slotSetFrom();

/** 
 The URL-Label "http://bugs.kde.org/" was clicked.
   
*/
	protected native void slotUrlClicked( String arg1);

/** 
 OK has been clicked
   
*/
	protected native void slotOk();

/** 
 Cancel has been clicked
   
*/
	protected native void slotCancel();
	protected native void appChanged( int arg1);
	protected native void updateURL();
}
