/***************************************************************************
                            KDCOPActionProxy.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KDCOPActionProxy class provides an easy way to publish a collection of {@link KAction} objects
 through DCOP. For the DCOP client the exported actions behave like full-fledged DCOP objects,
 providing full access to the KAction object functionality in the server.

 This class can generate DCOP object ids for given action objects, which it automatically
 processes, as being a {@link DCOPObjectProxy} .

 @short A proxy class publishing a DCOP interface for actions.
 
*/
public class KDCOPActionProxy extends DCOPObjectProxy  {
	protected KDCOPActionProxy(Class dummy){super((Class) null);}

	private native void newKDCOPActionProxy( KActionCollection actionCollection, DCOPObjectInterface parent);

/** 
 Constructs a dcop action proxy, being able to export the actions of the provided
 {@link KActionCollection} through DCOP, using the parent DCOPObject's object id to
 generate unique object ids for the actions.
   
*/
	public KDCOPActionProxy( KActionCollection actionCollection, DCOPObjectInterface parent) {
		super((Class) null);
		newKDCOPActionProxy( actionCollection, parent);
	}
	private native void newKDCOPActionProxy( DCOPObjectInterface parent);

/** 
 Use this constructor if do not want to provide the exportable actions through a
 {@link KActionCollection} . You have to reimplement the virtual {@link #actions} and
 {@link #action} methods if you use this constructor.
   
*/
	public KDCOPActionProxy( DCOPObjectInterface parent) {
		super((Class) null);
		newKDCOPActionProxy( parent);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a list of exportable actions. The default implementation returns a list of actions
 provided by a {@link KActionCollection}, if the first constructor has been used.
   
*/
//	public native QValueList<KAction*> actions();

/** 
 Returns an action object with the given name. The default implementation queries the action object
 from the {@link KActionCollection}, if the first constructor has been used.
   
*/
	public native KAction action( String name);

/** 
 Use this method to retrieve a DCOP object id for an action with the given name.
 This class automatically takes care of processing DCOP object requests for the returned
 object id.

 You can construct a global DCOP object referenence using DCOPRef. For example like
 DCOPRef( kapp.dcopClient().appId, actionProxy.actionObjectId( actionName ) );

 The action with the given name has to be available through the #action method.
   
*/
	public native String actionObjectId( String name);

/** 
 Returns a map of all exported actions, with the action name as keys and a global DCOP reference
 as data entries.
 The appId argument is used to specify the appid component of the DCOP reference. By default the
 global application id is used ( kapp.dcopClient().appId() ) .
   
*/
	public native String actionMap( String appId);

/** 
 Internal reimplementation of {@link DCOPObjectProxy#process} .
   
*/
	public native boolean process( String obj, String fun, byte[] data, String replyType, byte[] replyData);

/** 
 Called by the #process method and takes care of processing the object request for an
 action object.
   
*/
	public native boolean processAction( String obj, String fun, byte[] data, String replyType, byte[] replyData, KAction action);
	protected native void virtual_hook( int identifier, int data);
}
