/***************************************************************************
                            KFileMetaInfo.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 This is the class for objects that hold meta information about a file.
 The information is kept in form of a system of key/value pairs. See also
 {@link KFileMetaInfoItem}.
 This information is retrieved from the file through a plugin system, and
 this class is the main interface to it.
 If you want to write your own plugin, have a look at {@link KFilePlugin}.
 There are basically two different kinds of meta information: Fixed ones
 that the plugin knows about (e.g. an mp3 id3v1 tag has a well defined
 fixed list of fields), and variable keys that exist in mimetypes that
 support their own key/value system (comments in png files are of this type).
 Almost every file has fixed keys, but some also have variable keys.

 The groups and the What enum are not yet supported, but already added to
 the interface so that adding support doesn't break compatibility.

 
 @short *

*/
public class  KFileMetaInfo implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KFileMetaInfo(Class dummy){}

	private native void newKFileMetaInfo( String path, String mimeType, int what);

/** 
 The constructor.

 creating a KFileMetaInfo item through this will autoload the plugin
 belonging to the mimetype and try to get meta information about
 the specified file.

 If no info is available, you'll get an empty (not invalid) object.
 You can test for it with the {@link #isEmpty} method.

*/
	public KFileMetaInfo( String path, String mimeType, int what) {
		newKFileMetaInfo( path, mimeType, what);
	}
	private native void newKFileMetaInfo( String path);
	public KFileMetaInfo( String path) {
		newKFileMetaInfo( path);
	}
	private native void newKFileMetaInfo();

/** 
 Default constructor. This will create an invalid object (see
 {@link #isValid}.

*/
	public KFileMetaInfo() {
		newKFileMetaInfo();
	}
//	private native void newKFileMetaInfo( KFileMetaInfo* original);

/** 
 Copy constructor

*/
//	public KFileMetaInfo( KFileMetaInfo* original) {
//		newKFileMetaInfo( original);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native ArrayList groups();
	public native ArrayList supportedGroups();
	public native ArrayList preferredGroups();
	public native ArrayList preferredKeys();
	public native ArrayList supportedKeys();

/** 

*/
	public native ArrayList editableGroups();
	public native KFileMetaInfoItem item( String key);
	public native KFileMetaInfoItem item( int hint);
	public native KFileMetaInfoItem saveItem( String key, String preferredGroup, boolean createGroup);
	public native KFileMetaInfoItem saveItem( String key);
//	public native KFileMetaInfoGroup group( String key);

/** 
 Try to add the specified group. This will only succeed if it is
 in the list of {@link #editableGroups}. Note that all non-variable
 items that belong to this group are automatically added as empty
 item.
    
*/
	public native boolean addGroup( String name);

/** 
 remove the specified group. This will only succeed if it is
 in the list of {@link #editableGroups}. Beware that this also
 removes all the items in that group, so always ask the user
 before removing it!
    
*/
	public native boolean removeGroup( String name);
	public native ArrayList removedGroups();

/** 
 This method writes all pending changes of the meta info back to the file.
 If any items are marked as removed, they are really removed from the
 list. The info object as well as all items are updated.

*/
	public native boolean applyChanges();

/** 

*/
	public native boolean contains( String key);

/** 

*/
	public native boolean containsGroup( String key);
	public native QVariant value( String key);

/** 

*/
	public native boolean isValid();

/** 

*/
	public native boolean isEmpty();
	public native String mimeType();
	public native String path();
//	protected native KFileMetaInfoGroup appendGroup( String name);

/** 

*/
//	protected native KFilePlugin plugin();
	protected native void ref();
	protected native void deref();
	public static final int Fastest = 0x1;
	public static final int DontCare = 0x2;
	public static final int TechnicalInfo = 0x4;
	public static final int ContentInfo = 0x8;
	public static final int ExtenedAttr = 0x10;
	public static final int Thumbnail = 0x20;
	public static final int Preferred = 0x40;
	public static final int Everything = 0xffff;
}
