/***************************************************************************
                            KIconButton.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A pushbutton for choosing an icon. Pressing on the button will open a
 KIconDialog for the user to select an icon. The current icon will be
 displayed on the button.

 See {@link KIconButtonSignals} for signals emitted by KIconButton.

 

 @short A push button that allows selection of an icon.
 
*/
public class KIconButton extends QPushButton  {
	protected KIconButton(Class dummy){super((Class) null);}

	private native void newKIconButton( QWidget parent, String name);

/** 
 Constructs a KIconButton using the global iconloader.
     
*/
	public KIconButton( QWidget parent, String name) {
		super((Class) null);
		newKIconButton( parent, name);
	}
	private native void newKIconButton();
	public KIconButton() {
		super((Class) null);
		newKIconButton();
	}
	private native void newKIconButton( KIconLoader loader, QWidget parent, String name);

/** 
 Constructs a KIconButton using a specific KIconLoader.
     
*/
	public KIconButton( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconButton( loader, parent, name);
	}
	private native void newKIconButton( KIconLoader loader, QWidget parent);
	public KIconButton( KIconLoader loader, QWidget parent) {
		super((Class) null);
		newKIconButton( loader, parent);
	}

/** 
 Destructs the button.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in setIconType are allowed,
 and only icons of that size will be shown in the icon dialog.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Returns true if a strict icon size policy is set.
     
*/
	public native boolean strictIconSize();

/** 
 Sets the icon group and context. Use KIcon.NoGroup if you want to
 allow icons for any group in the given context.
     
*/
	public native void setIconType( int group, int context, boolean user);
	public native void setIconType( int group, int context);

/** 
 Sets the button's initial icon.
     
*/
	public native void setIcon( String icon);

/** 
 Resets the icon (reverts to an empty button).
     
*/
	public native void resetIcon();

/** 
 Returns the name of the selected icon.
     
*/
	public native String iconName();

/** 
 Sets the size of the icon to be shown / selected.

*/
	public native void setIconSize( int size);

/** 
 Returns the iconsize set via {@link #setIconSize} or 0, if the default
 iconsize will be used.
     
*/
	public native int iconSize();
}
