/***************************************************************************
                            KIconView.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This Widget extends the functionality of QIconView to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal executed(). It gets connected to either
 {@link QIconView#clicked} or {@link QIconView#doubleClicked} depending on the KDE
 wide Single Click/Double Click settings. It is strongly recomended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 {@link QIconView#selectionChanged} signal.

 See {@link KIconViewSignals} for signals emitted by KIconView.

 

 @short A variant of QIconView that honors KDE's system-wide settings.

*/
public class KIconView extends QIconView  {
	protected KIconView(Class dummy){super((Class) null);}

	private native void newKIconView( QWidget parent, String name, int f);
	public KIconView( QWidget parent, String name, int f) {
		super((Class) null);
		newKIconView( parent, name, f);
	}
	private native void newKIconView();
	public KIconView() {
		super((Class) null);
		newKIconView();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the mode to Execute or Select.

 Default is Execute.
   
*/
	public native void setMode( int m);

/** 

*/
	public native int mode();

/** 
 Reimplemented for internal purposes
   
*/
	public native void setFont( QFont arg1);
	protected native void emitExecute( QIconViewItem item, QPoint pos);
	protected native void focusOutEvent( QFocusEvent fe);
	protected native void leaveEvent( QEvent e);
	protected native void contentsMousePressEvent( QMouseEvent e);
	protected native void contentsMouseDoubleClickEvent( QMouseEvent e);
	protected native void contentsMouseReleaseEvent( QMouseEvent e);
	protected native void virtual_hook( int identifier, int data);
	protected native void slotOnItem( QIconViewItem item);
	protected native void slotOnViewport();
	protected native void slotSettingsChanged( int arg1);

/** 
 Auto selection happend.
   
*/
	protected native void slotAutoSelect();
	public static final int Execute = 0;
	public static final int Select = 1;
}
