/***************************************************************************
                            KProcIO.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KProcIO

 This class provides a slightly simpler interface to the communication
  functions provided by KProcess.  The simplifications are:

 Basically, KProcIO gives you buffered I/O similar to fgets()/fputs().

 Aside from these, and the fact that start() takes different
 parameters, use this class just like {@link KProcess}.

 See {@link KProcIOSignals} for signals emitted by KProcIO.

 

 @author David Sweet

 @version $Id: KProcIO.java,v 1.7 2002/11/26 04:17:33 rdale Exp $

 @short A slightly simpler interface to KProcess.
*/
public class KProcIO extends KProcess  {
	protected KProcIO(Class dummy){super((Class) null);}

	private native void newKProcIO( QTextCodec codec);
	public KProcIO( QTextCodec codec) {
		super((Class) null);
		newKProcIO( codec);
	}
	private native void newKProcIO();
	public KProcIO() {
		super((Class) null);
		newKProcIO();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
  Starts the process. It will fail in the following cases:

*/
	public native boolean start( int runmode, boolean includeStderr);
	public native boolean start();

/** 
 Writes text to stdin of the process.

*/
	public native boolean writeStdin( String line, boolean appendnewline);
	public native boolean writeStdin( String line);

/** 
 Writes text to stdin of the process.

*/
//	public native boolean writeStdin( String line, boolean appendnewline);

/** 
 Writes data to stdin of the process.

*/
	public native boolean writeStdin( byte[] data);

/** 
 This function just calls {@link #writeStdin}.

*/
	public native boolean fputs( String line, boolean AppendNewLine);
	public native boolean fputs( String line);

/** 
 closes stdin after all data has been send.
   
*/
	public native void closeWhenDone();

/** 
 Reads a line of text (up to and including '\n').

 Use readln() in response to a readReady() signal.
 You may use it multiple times if more than one line of data is
  available.
 Be sure to use ackRead() when you have finished processing the
  readReady() signal.  This informs KProcIO that you are ready for
  another readReady() signal.

 readln() never blocks.

 autoAck==TRUE makes these functions call ackRead() for you.

*/
	public native int readln( String line, boolean autoAck, boolean[] partial);
	public native int readln( String line);

/** 
 This function calls {@link #readln}.

*/
	public native int fgets( String line, boolean autoAck);
	public native int fgets( String line);

/** 
 Reset the class.  Doesn't kill the process.

*/
	public native void resetAll();

/** 
 Call this after you have finished processing a readReady()
 signal.  This call need not be made in the slot that was signalled
 by readReady().  You won't receive any more readReady() signals
 until you acknowledge with ackRead().  This prevents your slot
 from being reentered while you are still processing the current
 data.  If this doesn't matter, then call ackRead() right away in
 your readReady()-processing slot.

*/
	public native void ackRead();

/** 
  Turns {@link #readReady} signals on and off.
   You can turn this off at will and not worry about losing any data.
   (as long as you turn it back on at some point...)

*/
	public native void enableReadSignals( boolean enable);
	protected native void controlledEmission();
	protected native void virtual_hook( int identifier, int data);
	protected native void received( KProcess proc, String buffer, int buflen);
	protected native void sent( KProcess arg1);
}
