/***************************************************************************
                            KSpell.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDE Spellchecker

 A KDE programmer's interface to International ISpell 3.1.  (GPL 1997)
 A static method, {@link #modalCheck} is provided for convenient
  access to the spellchecker.

 See {@link KSpellSignals} for signals emitted by KSpell.

 

 @author David Sweet <dsweet@kde.org>

 @version $Id: KSpell.java,v 1.7 2002/11/26 04:17:34 rdale Exp $

 @short *
 KDE Spellchecker

*/
public class KSpell extends QObject  {
	protected KSpell(Class dummy){super((Class) null);}

	private native void newKSpell( QWidget parent, String caption, QObject receiver, String slot, KSpellConfig kcs, boolean progressbar, boolean modal);

/** 
 Starts the spellchecker.

 KSpell emits {@link #ready} when it has verified that
 ISpell/ASpell is working properly. Pass the name of a slot -- do not pass zero!
 Be sure to call {@link #cleanUp} when you are done with KSpell.

 If KSpell could not be started correctly, {@link #death} is emitted.

*/
	public KSpell( QWidget parent, String caption, QObject receiver, String slot, KSpellConfig kcs, boolean progressbar, boolean modal) {
		super((Class) null);
		newKSpell( parent, caption, receiver, slot, kcs, progressbar, modal);
	}
	private native void newKSpell( QWidget parent, String caption, QObject receiver, String slot);
	public KSpell( QWidget parent, String caption, QObject receiver, String slot) {
		super((Class) null);
		newKSpell( parent, caption, receiver, slot);
	}

/** 
 Returns the status of KSpell.

*/
	public native int status();

/** 
 Cleans up ISpell.

 Write out the personal dictionary and close ISpell's
  stdin.  A {@link #death} signal will be emitted when the cleanup is
  complete, but this method will return immediately.
   
*/
	public native void cleanUp();

/** 
 Sets the auto-delete flag. If this is set, the KSpell object
 is automatically deleted after emitting {@link #death}.
   
*/
	public native void setAutoDelete( boolean _autoDelete);

/** 
  Spellchecks a buffer of many words in plain text
  format.

 The <code>_buffer</code> is not modified.  The signal {@link #done} will be
  sent when {@link #check} is finished and the argument will be a
  spell-corrected version of <code>_buffer.</code>

 The spell check may be stopped by the user before the entire buffer
  has been checked.  You can check {@link #lastPosition} to see how far
  in <code>_buffer</code> {@link #check} reached before stopping.
   
*/
	public native boolean check( String _buffer, boolean usedialog);
	public native boolean check( String _buffer);

/** 
 Returns the position (when using {@link #check})  or word
 number (when using {@link #checkList}) of
 the last word checked.
   
*/
	public native int lastPosition();

/** 
 Spellchecks a list of words.

 {@link #checkList} is more flexible than {@link #check}.  You could parse
  any type
  of document (HTML, TeX, etc.) into a list of spell-checkable words
  and send the list to {@link #checkList}.  Sending a marked-up document
  to {@link #check} would result in the mark-up tags being
  spell checked.
   
*/
	public native boolean checkList( String[] _wordlist, boolean usedialog);
	public native boolean checkList( String[] _wordlist);

/** 
 Spellchecks a single word.

 checkWord() is the most flexible function.  Some applications
  might need this flexibility but will sacrifice speed when
  checking large numbers of words.  Consider {@link #checkList} for
  checking many words.

  Use this method for implementing  "online" spellchecking (i.e.,
  spellcheck as-you-type).

 checkWord() returns <code>false</code> if <code>buffer</code> is not a single word (e.g.
  if it contains white space), otherwise it returns <code>true</code>;

 If <code>usedialog</code> is set to <code>true</code>, KSpell will open the standard
  dialog if the word is not found.  The dialog results can be queried
  by using  {@link #dlgResult} and {@link #replacement}.

  The signal {@link #corrected} is emitted when the check is
  complete.  You can look at {@link #suggestions} to see what the
  suggested replacements were.
   
*/
	public native boolean checkWord( String _buffer, boolean usedialog);
	public native boolean checkWord( String _buffer);

/** 
 Hides the dialog box.

 You'll need to do this when you are done with {@link #checkWord};
   
*/
	public native void hide();

/** 
 Returns list of suggested word replacements.

 After calling {@link #checkWord} (an in response to
  a {@link #misspelled} signal you can
  use this to get the list of
  suggestions (if any were available).
   
*/
	public native ArrayList suggestions();

/** 
 Gets the result code of the dialog box.

 After calling checkWord, you can use this to get the dialog box's
  result code.
 The possible
  values are (from kspelldlg.h):

   
*/
	public native int dlgResult();

/** 
 Moves the dialog.

 If the dialog is not currently visible, it will
   be placed at this position when it becomes visible.
 Use this to get the dialog out of the way of a highlighted
 misspelled word in a document.
   
*/
	public native void moveDlg( int x, int y);

/** 
 Returns the height of the dialog box.
   
*/
	public native int heightDlg();

/** 
 Returns the width of the dialog box.
   
*/
	public native int widthDlg();

/** 
 Returns the partially spellchecked buffer.

 You might want the full buffer in its partially-checked state.
   
*/
	public native String intermediateBuffer();

/** 
 Tells ISpell/ASpell to ignore this word for the life of this KSpell instance.

*/
	public native boolean ignore( String word);

/** 
 Adds a word to the user's personal dictionary.

*/
	public native boolean addPersonal( String word);

/** 

*/
	public native KSpellConfig ksConfig();

/** 
 Sets the resolution (in percent) of the {@link #progress} signals.

 E.g. {@link #setProgressResolution} instructs KSpell to send progress
  signals (at most) every 10% (10%, 20%, 30%...).
 The default is 10%.
   
*/
	public native void setProgressResolution( int res);

/** 
 The destructor instructs ISpell/ASpell to write out the personal
  dictionary and then terminates ISpell/ASpell.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Call {@link #setIgnoreUpperWords} to tell the spell-checker to ignore
 words that are completely uppercase. They are spell-checked by default.
   
*/
	public native void setIgnoreUpperWords( boolean b);

/** 
 Call {@link #setIgnoreTitleCase} to tell the spell-checker to ignore
 words with a 'title' case, i.e. starting with an uppercase letter.
 They are spell-checked by default.
   
*/
	public native void setIgnoreTitleCase( boolean b);

/** 
 Performs a synchronous spellcheck.

 This method does not return until spellchecking is done or canceled.
 Your application's GUI will still be updated, however.
   
*/
	public static native int modalCheck( String text);

/** 
 Performs a synchronous spellcheck.

 This method does not return until spellchecking is done or canceled.
 Your application's GUI will still be updated, however.

 This overloaded method uses the spell-check configuration passed as parameter.
   
*/
	public static native int modalCheck( String text, KSpellConfig kcs);

/** 
 Used for {@link #modalCheck.}
   
*/
	protected native int parseOneResponse( String _buffer, String word, String[] sugg);
	protected native String funnyWord( String word);
	protected native void dialog( String word, String[] sugg, String _slot);
	protected native String replacement();
	protected native void setUpDialog( boolean reallyusedialogbox);
	protected native void setUpDialog();
	protected native void emitProgress();
	protected native boolean cleanFputs( String s, boolean appendCR);
	protected native boolean cleanFputs( String s);
	protected native boolean cleanFputsWord( String s, boolean appendCR);
	protected native boolean cleanFputsWord( String s);
	protected native void startIspell();
	protected native boolean writePersonalDictionary();
	protected native void KSpell2( KProcIO arg1);
	protected native void checkWord2( KProcIO arg1);
	protected native void checkWord3();
	protected native void check2( KProcIO arg1);
	protected native void checkList2();
	protected native void checkList3a( KProcIO arg1);
	protected native void checkListReplaceCurrent();
	protected native void checkList4();
	protected native void dialog2( int dlgresult);
	protected native void check3();
	protected native void slotStopCancel( int arg1);
	protected native void ispellExit( KProcess arg1);
	protected native void emitDeath();
	protected native void ispellErrors( KProcess arg1, String arg2, int arg3);
	public static final int Starting = 0;
	public static final int Running = 0;
	public static final int Cleaning = 1;
	public static final int Finished = 2;
	public static final int Error = 3;
	public static final int Crashed = 4;
}
