/***************************************************************************
                            KStatusBar.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  Display status messages.

  You can insert text labels or custom widgets. Their geometry is managed
  internally. KStatusBar resizes itself, but positioning is left to
  {@link #KMainWindow}.

  A special type of item is a message which is a temporary text-message
  displayed on top of other items in full-width. Messages are visible for
  specified time, or until you call the slot {@link QStatusBar#clear}. See
  {@link QStatusBar#message} for details.

  KStatusBar inherits {@link QStatusBar}, you can freely use all {@link QStatusBar}
  methods.

  Empty text items are not visible. They will become visible when you change
  (add) text.

 See {@link KStatusBarSignals} for signals emitted by KStatusBar.

 

 @author Mark Donohoe (donohoe@kde.org) Maintained by Sven Radej <radej@kde.org>

 @version $Id: KStatusBar.java,v 1.7 2002/11/26 04:17:34 rdale Exp $
 
 @short KDE statusbar widget.
*/
public class KStatusBar extends QStatusBar  {
	protected KStatusBar(Class dummy){super((Class) null);}

	private native void newKStatusBar( QWidget parent, String name);

/** 
  Constructs a status bar. <code>parent</code> is usually {@link KMainWindow}.
   
*/
	public KStatusBar( QWidget parent, String name) {
		super((Class) null);
		newKStatusBar( parent, name);
	}
	private native void newKStatusBar();
	public KStatusBar() {
		super((Class) null);
		newKStatusBar();
	}

/** 
  Destructor.

  Deletes all internal objects.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
  Inserts a text label into the status bar.
  Paremeters <code>stretch</code> and  <code>permanent</code> are passed to
  {@link QStatusBar#addWidget} .

  If <code>permanent</code> is true, then item will be placed on the far right of
  the statusbar and will never be hidden by {@link QStatusBar#message}.

   
*/
	public native void insertItem( String text, int identifier, int stretch, boolean permanent);
	public native void insertItem( String text, int identifier);

/** 
  Inserts a fixed width text label into status bar. The width will be set
  according to <code>text</code>, but will remain fixed even if you change text.
  You can change fixed width by calling {@link setItemFixed}.

*/
	public native void insertFixedItem( String text, int identifier, boolean permanent);
	public native void insertFixedItem( String text, int identifier);

/** 
  Removes an item.

*/
	public native void removeItem( int identifier);

/** 
 Changes the text in a status bar field.

 The item will be resized to fit the text. If you change text to be empty,
 item will not be visible (untill you add some text).

*/
	public native void changeItem( String text, int identifier);

/** 
 Sets the alignment of item <code>id.</code> By default all fields are aligned
 <code>AlignHCenter</code> | <code>AlignVCenter.</code> See {@link QLabel#setAlignment} for details.

  
*/
	public native void setItemAlignment( int identifier, int align);

/** 
 Sets item <code>id</code> to have fixed width. This cannot be undone, but you can
 always set new fixed width.

*/
	public native void setItemFixed( int identifier, int width);
	public native void setItemFixed( int identifier);
	public static final int Toggle = 0;
	public static final int Show = 1;
	public static final int Hide = 2;
}
