/***************************************************************************
                            KDualColorButton.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDUALCOLORBUTTON_H
#define KDUALCOLORBUTTON_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 KDualColorButton allows the user to select two cascaded colors (usually a
 foreground and background color). Other features include drag and drop
 from other KDE color widgets, a reset to black and white control, and a
 swap colors control.

 When the user clicks on the foreground or background rectangle the
 rectangle is first sunken and the @ref -currentChanged signal is emitted.
 Further clicks will present a color dialog and emit either the @ref -fgChanged
 or @ref -bgChanged if a new color is selected.

 Note: With drag and drop when dropping a color the current selected color
 will be set, while when dragging a color it will use whatever color
 rectangle the mouse was pressed inside.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A widget for selecting two related colors.

*/
@interface KDualColorButton : QWidget 

/** 
 Constructs a new KDualColorButton using the default black and white
 colors.

     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name dialogParent: (QWidget *)dialogParent;
- init;

/** 
 Constructs a new KDualColorButton with the supplied foreground and
 background colors.
     
*/
- initWithColor: (QColor *)fgColor bgColor: (QColor *)bgColor parent: (QWidget *)parent name: (NSString *)name dialogParent: (QWidget *)dialogParent;
- initWithColor: (QColor *)fgColor bgColor: (QColor *)bgColor ;
- (void) dealloc;

/** 
 Returns the current foreground color.
     
*/
- (QColor*) foreground;

/** 
 Returns the current background color.
     
*/
- (QColor*) background;

/** 
 Returns the current color item selected by the user.
     
*/
- (int) current;

/** 
 Returns the color of the selected item.
     
*/
- (QColor*) currentColor;

/** 
 Returns the minimum size needed to display the widget and all its
 controls.
     
*/
- (QSize*) sizeHint;

/** 
 Sets the foreground color.
     
*/
- setForeground: (QColor *)c;

/** 
 Sets the background color.
     
*/
- setBackground: (QColor *)c;

/** 
 Sets the current selected color item.
     
*/
- setCurrent: (int)s;

/** 
 Sets the color of the selected item.
     
*/
- setCurrentColor: (QColor *)c;

/** 
 Sets the supplied rectangles to the proper size and position for the
 current widget size. You can reimplement this to change the layout
 of the widget. Restrictions are that the swap control will always
 be at the top right, the reset control will always be at the bottom
 left, and you must leave at least a 14x14 space in those corners.
     
*/
- metrics: (QRect*)fgRect bgRect: (QRect*)bgRect;
+ (int) Foreground;
+ (int) Background;
@end

/** Override these methods in subclasses of KDualColorButton to customise event handling behaviour */
@protocol KDualColorButtonEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) ev;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) ev;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) ev;
- dragEnterEvent:(QDragEnterEvent*) ev;
- mouseMoveEvent:(QMouseEvent*) ev;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) ev;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
