/***************************************************************************
                            KSimpleConfig.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSIMPLECONFIG_H
#define KSIMPLECONFIG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KConfig.h>

/**

 KDE Configuration entries

 This is a trivial extension of @ref KConfig for applications that need
 only one configuration file and no default system.
 A difference with KConfig is that when the data in memory is written back
 it is not merged with what is on disk.
 Whatever is in memory simply replaces what is on disk entirely.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KSimpleConfig.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short KDE Configuration Management class with deletion ability.
*/
@interface KSimpleConfig : KConfig 

/** 
 Construct a KSimpleConfig object and make it either read-write
 or read-only.

*/
- initWithText: (NSString *)fileName bReadOnly: (BOOL)bReadOnly;
- initWithText: (NSString *)fileName ;

/** 
 Destructor.

 Writes back any dirty configuration entries.
   
*/
- (void) dealloc;
- sync;
@end

/** Override these methods in subclasses of KSimpleConfig to customise event handling behaviour */
@protocol KSimpleConfigEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
