/***************************************************************************
                            KStartupInfoId.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTARTUPINFOID_H
#define KSTARTUPINFOID_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Class representing an identification of application startup notification.

 Every existing notification about a starting application has its own unique
 identification, that's used to identify and manipulate the notification.

 @author Lubos Lunak <l.lunak@kde.org>

 @version $Id: KStartupInfoId.h,v 1.3 2002/03/15 02:12:23 rdale Exp $
 
 @short 
 Class representing an identification of application startup notification.
*/
@interface  KStartupInfoId : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 

*/
- (BOOL) none;

/** 
 Initializes this object with the given identification ( which may be also "0"
 for no notification ), or if "" is given, tries to read it from the startup
 notification environment variable, and if it's not set, creates a new one.
	 
*/
- initId: (NSString *)identifier;
- initId;

/** 

*/
- (NSString *) id;

/** 
 Sets the startup notification environment variable to this identification.
	 
*/
- (BOOL) setupStartupEnv;

/** 
 Creates an empty identification
	 
*/
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;
@end

#endif
