/***************************************************************************
                            KStringHandler.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTRINGHANDLER_H
#define KSTRINGHANDLER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**
 General description of this class:

 This class is @em not a substitute for the @ref QString class. What
 I tried to do with this class is provide an easy way to
 cut/slice/splice words inside sentences in whatever order desired.
 While the main focus of this class are words (ie characters
 separated by spaces/tabs), the two core functions here (@ref -split
 and @ref -join ) will function given any char to use as a separator.
 This will make it easy to redefine what a 'word' means in the
 future if needed.

 I freely stole some of the function names from python. I also think
 some of these were influenced by mIRC (yes, believe it if you will, I
 used to write a LOT of scripts in mIRC).

 The ranges are a fairly powerful way of getting/stripping words from
 a string. These ranges function, for the large part, as they would in
 python. See the @ref word and @ref remword functions for more detail.

 This class contains no data members of it own. All strings are cut
 on the fly and returned as new qstrings/qstringlists.

 Quick example on how to use:

 <pre>
 KStringHandler kstr;
 QString line = "This is a test of the strings";

 cout << "1> " << kstr.word( line , "4:" ) << "\n";
 cout << "2> " << kstr.remrange( line , "2:5" ) << "\n";
 cout << "2> " << kstr.reverse( line ) << "\n";
 cout << "2> " << kstr.center( kstr.word( line , 4 ) , 15 ) << "\n";
 </pre>

 and so forth.

 @author Ian Zepp <icszepp@islc.net>
 
 @short Class for manipulating words and sentences in strings.
*/
@class QRegExp; 

@interface  KStringHandler : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**  Returns the nth word in the string if found
 Returns a EMPTY (not null) string otherwise.
 Note that the FIRST index is 0
      
*/
+ (NSString *) word: (NSString *)text pos: (unsigned int)pos;

/**  Returns a range of words from that string.
 Ie:

 "0"        returns the very first word
 "0:"    returns the first the the last word
 "0:3"    returns the first to fourth words
 ":3"    returns everything up to the fourth word

 If you grok python, you're set.
      
*/
+ (NSString *) word: (NSString *)text range: (NSString *)range;

/**  Inserts a word into the string, and returns
 a new string with the word included. the first
 index is zero (0)
      
*/
+ (NSString *) insword: (NSString *)text word: (NSString *)word pos: (unsigned int)pos;

/**  Replaces a word in the string, and returns
 a new string with the word included. the first
 index is zero (0)
      
*/
+ (NSString *) setword: (NSString *)text word: (NSString *)word pos: (unsigned int)pos;

/**  Removes a word or ranges of words from the string,
 and returns a new string. The ranges definitions
 follow the definitions for the -word function.

 "0"        removes the very first word
 "0:"    removes the first the the last word
 "0:3"    removes the first to fourth words
 ":3"    removes everything up to the fourth word
      
*/
+ (NSString *) remrange: (NSString *)text range: (NSString *)range;

/**  Removes a word at the given index, and returns a
 new string. The first index is zero (0)
      
*/
+ (NSString *) remword: (NSString *)text pos: (unsigned int)pos;

/**  Removes a matching word from the string, and returns
 a new string. Note that only ONE match is removed.
      
*/
+ (NSString *) remword: (NSString *)text word: (NSString *)word;

/**  Capitalizes each word in the string
 "hello there" becomes "Hello There"        (string)
      
*/
+ (NSString *) capwords: (NSString *)text;

/**  Capitalizes each word in the list
 [hello, there] becomes [Hello, There]    (list)
      
*/
+ (NSArray *) capwordsFromList: (NSArray *)list;

/**  Reverses the order of the words in a string
 "hello there" becomes "there hello"        (string)
      
*/
+ (NSString *) reverse: (NSString *)text;

/**  Reverses the order of the words in a list
 [hello, there] becomes [there, hello]    (list)
      
*/
+ (NSArray *) reverseList: (NSArray *)list;

/**  These string justify a string along x, and returns a
 string at least 'width' characters wide, and justified.
 If the string is longer than the width, the original
 string is returned. It is never truncated.
 ljust    Left justify
 rjust    Right justify
 center    Centers
      
*/
+ (NSString *) ljust: (NSString *)text width: (unsigned int)width;
+ (NSString *) rjust: (NSString *)text width: (unsigned int)width;
+ (NSString *) center: (NSString *)text width: (unsigned int)width;

/**  Substitute characters at the beginning of a string by "...".

*/
+ (NSString *) lsqueeze: (NSString *)str maxlen: (unsigned int)maxlen;

/**  Substitute characters at the middle of a string by "...".

*/
+ (NSString *) csqueeze: (NSString *)str maxlen: (unsigned int)maxlen;

/**  Substitute characters at the end of a string by "...".

*/
+ (NSString *) rsqueeze: (NSString *)str maxlen: (unsigned int)maxlen;

/** 

*/
+ (BOOL) matchFileName: (NSString *)filename pattern: (NSString *)pattern;

/** 
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit("__", "some__string__for__you__here", 4)
 QStringList contains: "some", "string", "for", "you__here"

*/
+ (NSArray *) perlSplit: (NSString *)sep string: (NSString *)s maxlen: (unsigned int)max;

/** 
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit(' ', "kparts reaches the parts other parts can't", 3)
 QStringList contains: "kparts", "reaches", "the pats other parts can't"

*/
+ (NSArray *) perlSplitWithUnichar: (unichar *)sep string: (NSString *)s maxlen: (unsigned int)max;

/** 
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 perlSplit(QRegExp("[! ]", "Split me up ! I'm bored ! OK ?", 3)
 QStringList contains: "Split", "me", "up ! I'm bored, OK ?"

*/
+ (NSArray *) perlSplitWithRegExp: (QRegExp*)sep string: (NSString *)s maxlen: (unsigned int)max;
@end

#endif
