/***************************************************************************
* $Id: ListBoxDemo.java,v 1.1 2002/02/27 21:26:34 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;



class ListBoxDemo extends QWidget
{

private    QListBox  l;
private    QSpinBox  columns;
private    QSpinBox  rows;
private    QButtonGroup  bg;


ListBoxDemo()
{
    super( null, null );
    QGridLayout  g = new QGridLayout( this, 2, 2, 6 );

    g.addWidget( new QLabel( "<b>Configuration:</b>", this ), 0, 0 );
    g.addWidget( new QLabel( "<b>Result:</b>", this ), 0, 1 );

    l = new QListBox( this );
    g.addWidget( l, 1, 1 );
    l.setFocusPolicy( QWidget.StrongFocus );

    QVBoxLayout  v = new QVBoxLayout();
    g.addLayout( v, 1, 0 );

    QRadioButton  b = null;
    bg = new QButtonGroup( (QWidget) null );

    b = new QRadioButton( "Fixed number of columns,\n"
                          + "as many rows as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    b.setChecked( true );
    connect( b, SIGNAL("clicked()"), this, SLOT("setNumCols()") );
    QHBoxLayout  h = new QHBoxLayout();
    v.addLayout( h );
    h.addSpacing( 30 );
    h.addSpacing( 100 );
    h.addWidget( new QLabel( "Columns:", this ) );
    columns = new QSpinBox( this );
    h.addWidget( columns );

    v.addSpacing( 12 );

    b = new QRadioButton( "As many columns as fit on-screen,\n"
                          + "as many rows as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, SIGNAL("clicked()"), this, SLOT("setColsByWidth()") );

    v.addSpacing( 12 );

    b = new QRadioButton( "Fixed number of rows,\n"
                          + "as many columns as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, SIGNAL("clicked()"), this, SLOT("setNumRows()") );
    h = new QHBoxLayout();
    v.addLayout( h );
    h.addSpacing( 30 );
    h.addSpacing( 100 );
    h.addWidget( new QLabel( "Rows:", this ) );
    rows = new QSpinBox( this );
    rows.setEnabled( false );
    h.addWidget( rows );

    v.addSpacing( 12 );

    b = new QRadioButton( "As many rows as fit on-screen,\n"
                          + "as many columns as needed.",
                          this );
    bg.insert( b );
    v.addWidget( b );
    connect( b, SIGNAL("clicked()"), this, SLOT("setRowsByHeight()") );

    v.addSpacing( 12 );

    QCheckBox  cb = new QCheckBox( "Variable-height rows", this );
    cb.setChecked( true );
    connect( cb, SIGNAL("toggled(boolean)"), this, SLOT("setVariableHeight(boolean)") );
    v.addWidget( cb );
    v.addSpacing( 6 );

    cb = new QCheckBox( "Variable-width columns", this );
    connect( cb, SIGNAL("toggled(boolean)"), this, SLOT("setVariableWidth(boolean)") );
    v.addWidget( cb );

    cb = new QCheckBox( "Extended-Selection", this );
    connect( cb, SIGNAL("toggled(boolean)"), this, SLOT("setMultiSelection(boolean)") );
    v.addWidget( cb );

    QPushButton pb = new QPushButton( "Sort ascending", this );
    connect( pb, SIGNAL(" clicked()"), this, SLOT(" sortAscending()") );
    v.addWidget( pb );

    pb = new QPushButton( "Sort descending", this );
    connect( pb, SIGNAL(" clicked()"), this, SLOT(" sortDescending()") );
    v.addWidget( pb );

    v.addStretch( 100 );

    int i = 0;
    while( ++i <= 2560 )
        l.insertItem( "Item " + i,
                       i );
    columns.setRange( 1, 256 );
    columns.setValue( 1 );
    rows.setRange( 1, 256 );
    rows.setValue( 256 );

    connect( columns, SIGNAL("valueChanged(int)"), this, SLOT("setNumCols()") );
    connect( rows, SIGNAL("valueChanged(int)"), this, SLOT("setNumRows()") );
}


void setNumRows()
{
    columns.setEnabled( false );
    rows.setEnabled( true );
	// In java, setNumRows(int) sets the number of rows, not setRowMode(int)
    l.setNumRows( rows.value() );
}


void setNumCols()
{
    columns.setEnabled( true );
    rows.setEnabled( false );
	// In java, setNumColumns(int) sets the number of columns, not setColumnMode(int)
    l.setNumColumns( columns.value() );
}


void setRowsByHeight()
{
    columns.setEnabled( false );
    rows.setEnabled( false );
    l.setRowMode( QListBox.FitToHeight );
}


void setColsByWidth()
{
    columns.setEnabled( false );
    rows.setEnabled( false );
    l.setColumnMode( QListBox.FitToWidth );
}


void setVariableWidth( boolean b )
{
    l.setVariableWidth( b );
}


void setVariableHeight( boolean b )
{
    l.setVariableHeight( b );
}

void setMultiSelection( boolean b )
{
    l.clearSelection();
    l.setSelectionMode( b ? QListBox.Extended : QListBox.Single );
}

void sortAscending()
{
    l.sort( true );
}

void sortDescending()
{
    l.sort( false );
}
}
