package org.kde.qt;


/** {@link QIconView} emits these signals */
public interface QIconViewSignals {
	void pressed( QIconViewItem arg1, QPoint arg2 );
	void verticalSliderPressed();
	void horizontalSliderPressed();
	void rightButtonClicked( QIconViewItem item, QPoint pos );
	void rightButtonPressed( QIconViewItem item, QPoint pos );
	void onViewport();
	void onItem( QIconViewItem item );
	void returnPressed( QIconViewItem item );
	void contentsMoving( int x, int y );
//	void dropped( QDropEvent e, QIconDragItemValueList lst );
	void currentChanged( QIconViewItem item );
	void itemRenamed( QIconViewItem item );
	void destroyed( QObject obj );
	void contextMenuRequested( QIconViewItem item, QPoint pos );
	void verticalSliderReleased();
	void selectionChanged( QIconViewItem item );
	void moved();
	void doubleClicked( QIconViewItem item );
	void horizontalSliderReleased();
	void mouseButtonClicked( int button, QIconViewItem item, QPoint pos );
	void mouseButtonPressed( int button, QIconViewItem item, QPoint pos );
	void clicked( QIconViewItem arg1, QPoint arg2 );
}

