/***************************************************************************
                            QListView.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QLISTVIEW_H
#define QLISTVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>
#include <qtobjc/QHeader.h>

@class QListViewItem;
@class QContextMenuEvent;
@class QDragObject; 
@class QIMEvent; 
@class QPalette; 
@class QStyle; 
@class QTabletEvent; 

@interface QListView : QScrollView 
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- (void) dealloc;
- (int) treeStepSize;
- setTreeStepSize: (int)arg1;
- insertListViewItem: (QListViewItem *)arg1;
- takeItem: (QListViewItem *)arg1;
- removeListViewItem: (QListViewItem *)item;
- (QHeader*) header;
- (int) addColumn: (NSString *)label size: (int)size;
- (int) addColumn: (NSString *)label ;
- (int) addColumn: (QIconSet*)iconset label: (NSString *)label size: (int)size;
- (int) addColumn: (QIconSet*)iconset label: (NSString *)label ;
- removeColumn: (int)index;
- setColumnText: (int)column label: (NSString *)label;
- setColumnText: (int)column iconset: (QIconSet*)iconset label: (NSString *)label;
- (NSString *) columnText: (int)column;
- setColumnWidth: (int)column width: (int)width;
- (int) columnWidth: (int)column;
- setColumnWidthMode: (int)column int: (int)arg1;
- (int) columnWidthMode: (int)column;
- (int) columns;
- setColumnAlignment: (int)arg1 int: (int)arg2;
- (int) columnAlignment: (int)arg1;
- show;
- (QListViewItem*) itemAt: (QPoint*)screenPos;
- (QRect*) itemRect: (QListViewItem *)arg1;
- (int) itemPos: (QListViewItem *)arg1;
- ensureItemVisible: (QListViewItem *)arg1;
- repaintItem: (QListViewItem *)arg1;
- setMultiSelection: (BOOL)enable;
- (BOOL) isMultiSelection;
- setSelectionMode: (int)mode;
- (int) selectionMode;
- clearSelection;
- setSelected: (QListViewItem *)arg1 bool: (BOOL)arg2;
- (BOOL) isSelected: (QListViewItem *)arg1;
- (QListViewItem*) selectedItem;
- setOpen: (QListViewItem *)arg1 bool: (BOOL)arg2;
- (BOOL) isOpen: (QListViewItem *)arg1;
- setCurrentItem: (QListViewItem *)arg1;
- (QListViewItem*) currentItem;
- (QListViewItem*) firstChild;
- (QListViewItem*) lastItem;
- (int) childCount;
- setAllColumnsShowFocus: (BOOL)arg1;
- (BOOL) allColumnsShowFocus;
- setItemMargin: (int)arg1;
- (int) itemMargin;
- setRootIsDecorated: (BOOL)arg1;
- (BOOL) rootIsDecorated;
- setSorting: (int)column increasing: (BOOL)increasing;
- setSorting: (int)column ;
- sort;
- setFont: (QFont *)arg1;
- setPalette: (QPalette *)arg1;
- (BOOL) eventFilter: (QObject *)o event: (QEvent *)arg1;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- setShowSortIndicator: (BOOL)show;
- (BOOL) showSortIndicator;
- setShowToolTips: (BOOL)b;
- (BOOL) showToolTips;
- setResizeMode: (int)m;
- (int) resizeMode;
- (QListViewItem*) findItem: (NSString *)text column: (int)column compare: (int)compare;
- (QListViewItem*) findItem: (NSString *)text column: (int)column ;
- setDefaultRenameAction: (int)a;
- (int) defaultRenameAction;
- (BOOL) isRenaming;
- clear;
- invertSelection;
- selectAll: (BOOL)select;
- triggerUpdate;
- setContentsPos: (int)x y: (int)y;
- (QDragObject*) dragObject;
- startDrag;
- drawContentsOffset: (QPainter *)arg1 ox: (int)ox oy: (int)oy cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- paintEmptyArea: (QPainter *)arg1 rect: (QRect*)arg2;
- styleChange: (QStyle*)arg1;
- windowActivationChange: (BOOL)arg1;
- updateContents;
- doAutoScroll;
+ (int) Manual;
+ (int) Maximum;
+ (int) Single;
+ (int) Multi;
+ (int) Extended;
+ (int) NoSelection;
+ (int) NoColumn;
+ (int) AllColumns;
+ (int) LastColumn;
+ (int) Accept;
+ (int) Reject;
@end

/** Override these methods in subclasses of QListView to customise event handling behaviour */
@protocol QListViewEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) e;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) e;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
