/***************************************************************************
                          geopoint.h  -  description
                             -------------------
    begin                : Sun Oct 29 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GEOPOINT_H
#define GEOPOINT_H

#include <geoobjects.h>

/** This is a class that represents all
	* kinds of points.
  *@author Marc Bartsch
  */

class GeoPoint : public GeoObjects
{
	public:

		GeoPoint( QPoint *pt=0 );
		virtual ~GeoPoint();

		virtual void				getObjectOverlay( QList <QRect> & list );

	  virtual void 				move();
	  virtual void 				move( QPoint *pt );

		virtual void 				paint( QPainter *p );
	  virtual bool 				contains( QPoint *pt );
	
		virtual void 				writeToFile( KSimpleConfig *config );
		virtual void 				readFromFile( KSimpleConfig *config );

	protected:

		bool 		use3D;
		double  position;
};

#endif

