#include "ai.h"
#include "ai.moc"

#include "board.h"


FEAI::FEAI(uint thinkTime, uint orderTime)
: AI(thinkTime, orderTime)
{
    const AIElement::Data rdata = { "removed eggs", false, nbRemoved };
    addElement(rdata);
    const AIElement::Data pdata = { "nb puyos", true, nbPuyos };
    addElement(pdata);
    const AIElement::Data cdata = { "nb chained", true, nbChained };
    addElement(cdata);
}

int FEAI::nbPuyos(const Board &main, const Board &current)
{
    return static_cast<const FEBoard &>(current).nbPuyos()
        - static_cast<const FEBoard &>(main).nbPuyos();
}

int FEAI::nbChained(const Board &, const Board &current)
{
    return static_cast<const FEBoard &>(current).chained();
}
