//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMTEXTUREMAP_H
#define PMTEXTUREMAP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"
#include "pmvector.h"

#include <qvaluelist.h>

/**
 * Base class for color, pigment, texture and normal maps
 */ 

class PMTextureMapBase : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates a PMTextureMapBase */
   PMTextureMapBase( );
   /** deletes the PMTextureMapBase */
   virtual ~PMTextureMapBase( );

   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool dataChangeOnInsertRemove( ) const { return true; }

   /** */
   virtual void childAdded( PMObject* o );
   /** */
   virtual bool takeChild( PMObject* o );
   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   
   /** Returns a new @ref PMTextureMapEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;

   /** */
   virtual void createMemento( );
   /** */
   virtual void restoreMemento( PMMemento* s );

   /** Returns the map values */
   QValueList<double> mapValues( ) const { return m_mapValues; }
   /** Sets the map values */
   void setMapValues( const QValueList<double>& v );
   /** Returns the map value for the object o */
   double mapValue( const PMObject* o ) const;
   
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const = 0;
   
private:
   PMObject* nextMapEntry( PMObject* o );
   void stringToValues( const QString& str );
   QString valuesToString( ) const;
   QValueList<double>::Iterator valueForChild( PMObject* o );
   
   /** IDs for @ref PMMementoData */
   // enum PMTextureMapBaseMementoID { };

   /** list of map values */
   QValueList<double> m_mapValues;
   /** removed map values */
   QValueList<double> m_removedValues;
   
};


/**
 * Class for texture maps
 */

class PMTextureMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a texture map */
   PMTextureMap( );
   /** Deletes the texture map */
   virtual ~PMTextureMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMTextureMap( ); }
   /** */
   virtual QString className( ) const { return QString( "texturemap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTTextureMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmtexturemap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTTexture; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};

/**
 * Class for pigment maps
 */

class PMPigmentMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a pigment map */
   PMPigmentMap( );
   /** Deletes the pigment map */
   virtual ~PMPigmentMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMPigmentMap( ); }
   /** */
   virtual QString className( ) const { return QString( "pigmentmap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTPigmentMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmpigmentmap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTPigment; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};

/**
 * Class for color maps
 */

class PMColorMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a color map */
   PMColorMap( );
   /** Deletes the color map */
   virtual ~PMColorMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMColorMap( ); }
   /** */
   virtual QString className( ) const { return QString( "colormap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTColorMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmcolormap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTSolidColor; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


/**
 * Class for normal maps
 */

class PMNormalMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a normal map */
   PMNormalMap( );
   /** Deletes the normal map */
   virtual ~PMNormalMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMNormalMap( ); }
   /** */
   virtual QString className( ) const { return QString( "normalmap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTNormalMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmnormalmap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTNormal; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};

/**
 * Class for slope maps
 */

class PMSlopeMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a slope map */
   PMSlopeMap( );
   /** Deletes the slope map */
   virtual ~PMSlopeMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMSlopeMap( ); }
   /** */
   virtual QString className( ) const { return QString( "slopemap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTSlopeMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmslopemap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTSlope; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};

/**
 * Class for density maps
 */

class PMDensityMap : public PMTextureMapBase
{
public:
   typedef PMTextureMapBase Base;
   /** Creates a density map */
   PMDensityMap( );
   /** Deletes the density map */
   virtual ~PMDensityMap( );

   /** */
   virtual PMObject* newObject( ) const { return new PMDensityMap( ); }
   /** */
   virtual QString className( ) const { return QString( "densitymap" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTDensityMap; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmdensitymap" ); }
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;
   /** Returns the map object type */
   virtual PMObjectType mapType( ) const { return PMTDensity; }
   /** */
   void serialize( PMOutputDevice& dev ) const;

private:
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};

#endif
