/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2002 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CATALOGPRIVATE_H
#define CATALOGPRIVATE_H

#include <qintcache.h>
#include <qobject.h>
#include <qptrlist.h>
#include <qmap.h>
#include <kurl.h>

#include "catalogsettings.h"
#include "catalogitem.h"
#include "msgfmt.h"

class QString;
class QTextStream;
class KFileInfo;
class QTextCodec;
class QFile;
class FindOptions;
class KConfig;

class CatalogPrivate
{

public:

   /** url of the po-file, that belongs to this catalog */
   KURL _url;
   QString _packageName;
   QString _packageDir;

   /** holds the entries in the catalog */
   QValueList<CatalogItem> _entries;
   /** The header of the po-file. */
   CatalogItem _header;
   
   /** list of comments with obsolete entries */
   QValueList<QString> _obsolete;

   bool _modified;
   bool _readOnly;
   bool _generatedFromDocbook;

   QValueList<uint> _fuzzyIndex;
   QValueList<uint> _untransIndex;
   QValueList<uint> _errorIndex;

   QPtrList<CatalogView> _views;

   SaveSettings _saveSettings;
   IdentitySettings _identitySettings;
   MiscSettings _miscSettings;

   QPtrList<EditCommand> _undoList;
   QPtrList<EditCommand> _redoList;

   QTextCodec *fileCodec;

   QStringList msgidDiffList;
   QMap< QString, QStringList > msgstr2MsgidDiffList;
   QIntCache<QString> diffCache;
   
   int numberOfPluralForms;

   QString _configFile;
   
   CatalogPrivate() : 
	_packageName( QString::null ), _packageDir( QString::null ),
	_modified(false), _readOnly(false), _generatedFromDocbook(false), 
	fileCodec(0),  diffCache(30,76), numberOfPluralForms(-1), 
	_configFile( QString::null )
   {
	diffCache.setAutoDelete(true);
	diffCache.clear();
	
	_views.setAutoDelete(false);
	
	_undoList.setAutoDelete(true);
	_redoList.setAutoDelete(true);
   }
};

#endif //CATALOGPRIVATE_H
