#ifndef XMLBUGJOB_H
#define XMLBUGJOB_H

#include <kio/jobclasses.h>

#include "bugserver.h"

class XmlBugJob : public KIO::Job
{
    Q_OBJECT
  public:
    XmlBugJob( BugServer * );
    virtual ~XmlBugJob();

    BugServer *server() const { return mServer; }

    DomProcessor *dom() const { return mServer->domProcessor(); }

  signals:
    void infoMessage( const QString &text );
    void infoPercent( unsigned long percent );
    void error( const QString &text );

  protected:
    void start( const KURL &url /*, const KParts::URLArgs &args = KParts::URLArgs()*/ );

    virtual void process( const QByteArray &data ) = 0;

  private slots:
    void ioResult( KIO::Job *job );

    void ioData( KIO::Job *job, const QByteArray &data );

    void ioInfoMessage( KIO::Job *job, const QString &text );

    void ioInfoPercent( KIO::Job *job, unsigned long percent );

  private:
    QByteArray m_data;
    BugServer *mServer;
};

#endif
/*
 * vim:sw=4:ts=4:et
 */
