/*****************************************************************************\
  scaler.cpp : Implimentation for the Scaler class

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifdef APDK_PROTO
#include "../common/header.h"
#else
#include "header.h"
#endif

APDK_BEGIN_NAMESPACE

#define MAX_OUTPUT_RASTERS 32


Scaler::Scaler(SystemServices* pSys,unsigned int inputwidth,
               unsigned int numerator,unsigned int denominator, BOOL vip, unsigned int BytesPerPixel)
        : pSS(pSys), iInputWidth(inputwidth)
{

    ASSERT(denominator > 0);

    constructor_error=NO_ERROR;

    ScaleFactor= (float)numerator / (float)denominator;
    if (ScaleFactor > (float)MAX_OUTPUT_RASTERS)      //
    {
        constructor_error = INDEX_OUT_OF_RANGE;
        return;
    }
    int factor = (int)ScaleFactor;
    float rem = ScaleFactor - (float)factor;
    rem *= 1000;
    remainder = (int)rem;

    iOutputWidth = (int)(
                             ((float)iInputWidth / (float)denominator) *
                                (float)numerator);
    iOutputWidth++;         // safety measure to protect against roundoff error

    if (numerator == denominator)
        scaling=FALSE;
    else scaling=TRUE;


    // ScaleBound=max number of output rows per input row;
    // i.e., if scale=4.28, then sometimes 5 rows will come out

    int ScaleBound = int(ScaleFactor);
    if  (ScaleFactor > (float) ScaleBound)
        ScaleBound++;

    // allocate a buffer for one output row
    unsigned int bytecount;
    if (vip)
        bytecount=3;
    else bytecount=BytesPerPixel;
    int RSBuffSize= (int)(((float)(BytesPerPixel*iOutputWidth)) * ScaleBound );
    pOutputBuffer=(BYTE*)pSS->AllocMem(RSBuffSize);
    if (pOutputBuffer == NULL)
    {
        constructor_error=ALLOCMEM_ERROR;
        return;
    }

    if (ScaleFactor < 2.0)
        ReplicateOnly = TRUE;
    else ReplicateOnly=FALSE;

    if (ScaleFactor > (float)factor)
        fractional=TRUE;
    else fractional=FALSE;
}

Scaler::~Scaler()
{
    pSS->FreeMemory(pOutputBuffer);
}


unsigned int Scaler::GetOutputWidth()
{
    return (iOutputWidth-1)*NUMBER_PLANES;  // we padded it in case of roundoff error
}

APDK_END_NAMESPACE

