/***************************************************************************
                            kde_SynthOut.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_SYNTHOUT
#define KDE_SYNTHOUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Synth (AWE) device output class . SynthOut is used to send MIDI events to
 a general synthesizer, such as AWE synth.

 SynthOut inherits @ref MidiOut and supports the same simple API.

 The preferred way to use this class is by selecting a synth (or AWE)
 device with @ref MidiManager::setDefaultDevice(), and use a 
 @ref MidiManager object.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to AWE synthesizers.
*/

/** *
 Constructor. See @ref MidiOut::MidiOut() for more information.
     
*/
kde_SynthOut * kde_new_SynthOut(int d);

/** *
 Destructor.
     
*/
void kde_del_SynthOut( kde_SynthOut* p );

/** *
 See @ref MidiOut::openDev()
     
*/
void kde_SynthOut_openDev(kde_SynthOut* instPointer,int sqfd);

/** *
 See @ref MidiOut::closeDev()
     
*/
void kde_SynthOut_closeDev(kde_SynthOut* instPointer);

/** *
 See @ref MidiOut::initDev()
     
*/
void kde_SynthOut_initDev(kde_SynthOut* instPointer);

/** *
 See @ref MidiOut::noteOn()
     
*/
void kde_SynthOut_noteOn(kde_SynthOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::noteOff()
     
*/
void kde_SynthOut_noteOff(kde_SynthOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::keyPressure()
     
*/
void kde_SynthOut_keyPressure(kde_SynthOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** *
 See @ref MidiOut::chnPatchChange()
     
*/
void kde_SynthOut_chnPatchChange(kde_SynthOut* instPointer,unsigned char chn, unsigned char patch);

/** *
 See @ref MidiOut::chnPressure()
     
*/
void kde_SynthOut_chnPressure(kde_SynthOut* instPointer,unsigned char chn, unsigned char vel);

/** *
 See @ref MidiOut::chnPitchBender()
     
*/
void kde_SynthOut_chnPitchBender(kde_SynthOut* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** *
 See @ref MidiOut::chnController()
     
*/
void kde_SynthOut_chnController(kde_SynthOut* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** *
 It's an empty function, as AWE devices don't support System Exclusive
 messages
     
*/
void kde_SynthOut_sysex(kde_SynthOut* instPointer,unsigned char* data, unsigned long size);

#endif
