/***************************************************************************
                            KRootPixmap.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Creates pseudo-transparent widgets.

 A pseudo-transparent widget is a widget with its background pixmap set to
 that part of the desktop background that it is currently obscuring. This
 gives a transparency effect.

 To create a transparent widget, construct a KRootPixmap and pass it a
 pointer to your widget. That's it! Moving, resizing and background changes
 are handled automatically.

 Instead of using the default behaviour, you can ask KRootPixmap
 to emit a {@link #backgroundUpdated} signal whenever
 the background needs updating by using {@link #setCustomPainting}.
 Alternatively by reimplementing {@link #updateBackground}
 you can take complete control of the behaviour.

 See {@link KRootPixmapSignals} for signals emitted by KRootPixmap.

 

 @author Geert Jansen <jansen@kde.org>

 @version $Id: KRootPixmap.java,v 1.7 2002/11/26 04:17:34 rdale Exp $
 
 @short *
 Creates pseudo-transparent widgets.
*/
public class KRootPixmap extends QObject  {
	protected KRootPixmap(Class dummy){super((Class) null);}

	private native void newKRootPixmap( QWidget target, String name);

/** 
 Constructs a KRootPixmap. The KRootPixmap will be created as a child
 of the target widget so it will be deleted automatically when the
 widget is destroyed.

*/
	public KRootPixmap( QWidget target, String name) {
		super((Class) null);
		newKRootPixmap( target, name);
	}
	private native void newKRootPixmap( QWidget target);
	public KRootPixmap( QWidget target) {
		super((Class) null);
		newKRootPixmap( target);
	}
	private native void newKRootPixmap( QWidget target, QObject parent, String name);

/** 
 Constructs a KRootPixmap where the parent QObject and target QWidget are
 different.
     
*/
	public KRootPixmap( QWidget target, QObject parent, String name) {
		super((Class) null);
		newKRootPixmap( target, parent, name);
	}
	private native void newKRootPixmap( QWidget target, QObject parent);
	public KRootPixmap( QWidget target, QObject parent) {
		super((Class) null);
		newKRootPixmap( target, parent);
	}

/** 
 Destructs the object.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Checks if pseudo-transparency is available.

*/
	public native boolean isAvailable();

/** 
 Returns true if the KRootPixmap is active.
     
*/
	public native boolean isActive();

/** 
 Returns the number of the current desktop.
     
*/
	public native int currentDesktop();

/** 
 Returns true if custom painting is enabled, false otherwise.

*/
	public native boolean customPainting();

/** 
 Deprecated, use {@link #isAvailable} instead.

     
*/
	public native boolean checkAvailable( boolean arg1);

/** 
 Starts background handling.
     
*/
	public native void start();

/** 
 Stops background handling.
     
*/
	public native void stop();

/** 
 Sets the fade effect.

 This effect will fade the background to the
 specified color.

*/
	public native void setFadeEffect( double strength, QColor color);

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically.

*/
	public native void repaint( boolean force);

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically. This is equivalent to calling
 repaint( false ).
     
*/
	public native void repaint();

/** 
 Enables custom handling of the background painting. If custom
 painting is enabled then KRootPixmap will emit a
 {@link #backgroundUpdated} signal when the background for the
 target widget changes, instead of applying the new background.
     
*/
	public native void setCustomPainting( boolean enable);

/** 
 Asks KDesktop to export the desktop background as a KSharedPixmap.
 This method uses DCOP to call KBackgroundIface/setExport(int).
     
*/
	public native void enableExports();

/** 
 Reimplemented to filter the events from the target widget and
 track its movements.
     
*/
	public native boolean eventFilter( QObject arg1, QEvent arg2);

/** 
 Called when the pixmap has been updated. The default implementation
 applies the fade effect, then sets the target's background, or emits
 {@link #backgroundUpdated} depending on the painting mode.
     
*/
	protected native void updateBackground( KSharedPixmap arg1);
}
