/***************************************************************************
                            KToolBar.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KDE-style toolbar.

 KToolBar can be dragged around in and between different docks.

 A KToolBar can contain all sorts of widgets.

 KToolBar can be used as a standalone widget, but {@link KMainWindow}
 provides easy factories and management of one or more toolbars.
 Once you have a KToolBar object, you can insert items into it with the
 insert... methods, or remove them with the {@link #removeItem} method. This
 can be done at any time; the toolbar will be automatically updated.
 There are also many methods to set per-child properties like alignment
 and toggle behaviour.

 KToolBar uses a global config group to load toolbar settings on
 construction. It will reread this config group on a
 {@link KApplication#appearanceChanged} signal.

 See {@link KToolBarSignals} for signals emitted by KToolBar.

 

 @author Reginald Stadlbauer <reggie@kde.org>, Stephan Kulow <coolo@kde.org>, Sven Radej <radej@kde.org>.
  
 @version $Id: KToolBar.java,v 1.8 2002/11/26 04:17:35 rdale Exp $

 @short Floatable toolbar with auto resize.

*/
public class KToolBar extends QToolBar  {
	protected KToolBar(Class dummy){super((Class) null);}

	private native void newKToolBar( QWidget parent, String name, boolean honor_style, boolean readConfig);

/** 
 Constructor.
 This constructor is used by the XML-GUI. If you use it, you need
 to call QMainWindow.addToolBar to specify the position of the toolbar.
 So it's simpler to use the other constructor.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if {@link #_honor_mode} is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
	public KToolBar( QWidget parent, String name, boolean honor_style, boolean readConfig) {
		super((Class) null);
		newKToolBar( parent, name, honor_style, readConfig);
	}
	private native void newKToolBar( QWidget parent);
	public KToolBar( QWidget parent) {
		super((Class) null);
		newKToolBar( parent);
	}
	private native void newKToolBar( QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honor_style, boolean readConfig);

/** 
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if {@link #_honor_mode} is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
	public KToolBar( QMainWindow parentWindow, int dock, boolean newLine, String name, boolean honor_style, boolean readConfig) {
		super((Class) null);
		newKToolBar( parentWindow, dock, newLine, name, honor_style, readConfig);
	}
	private native void newKToolBar( QMainWindow parentWindow, int dock);
	public KToolBar( QMainWindow parentWindow, int dock) {
		super((Class) null);
		newKToolBar( parentWindow, dock);
	}
	private native void newKToolBar( QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honor_style, boolean readConfig);

/** 
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if {@link #_honor_mode} is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
	public KToolBar( QMainWindow parentWindow, QWidget dock, boolean newLine, String name, boolean honor_style, boolean readConfig) {
		super((Class) null);
		newKToolBar( parentWindow, dock, newLine, name, honor_style, readConfig);
	}
	private native void newKToolBar( QMainWindow parentWindow, QWidget dock);
	public KToolBar( QMainWindow parentWindow, QWidget dock) {
		super((Class) null);
		newKToolBar( parentWindow, dock);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Insert a button (a {@link KToolBarButton}) with a pixmap.  The
 pixmap is loaded by the button itself based on the global icon
 settings.

 You should connect to one or more signals in KToolBar:
 {@link #clicked} , {@link #pressed} , {@link #released} , or
 {@link #highlighted}  and if the button is a toggle button
 ({@link #setToggle} ) {@link #toggled} .  Those signals have <code>id</code>
 of a button that caused the signal.  If you want to bind a popup
 to button, see {@link #setButton}.

*/
	public native int insertButton( String icon, int identifier, boolean enabled, String text, int index, KInstanceInterface _instance);
	public native int insertButton( String icon, int identifier);

/** 
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with {@link #addConnection}.

*/
	public native int insertButton( String icon, int identifier, String signal, QObject receiver, String slot, boolean enabled, String text, int index, KInstanceInterface _instance);
	public native int insertButton( String icon, int identifier, String signal, QObject receiver, String slot);

/** 
 Inserts a button (a {@link KToolBarButton}) with the specified
 pixmap.  This pixmap will be used as the "active" one and the
 disabled and default ones will be autogenerated.

 It is recommended that you use the insertButton function that
 allows you to specify the icon name rather then the pixmap
 itself.  Specifying the icon name is much more flexible.

 You should connect to one or more signals in KToolBar:
 {@link #clicked} , {@link #pressed} , {@link #released} , or
 {@link #highlighted}  and if the button is a toggle button
 ({@link #setToggle} ) {@link #toggled} .  Those signals have <code>id</code>
 of a button that caused the signal.  If you want to bind a popup
 to button, see {@link #setButton}.

*/
	public native int insertButton( QPixmap pixmap, int identifier, boolean enabled, String text, int index);
	public native int insertButton( QPixmap pixmap, int identifier);

/** 
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with {@link #addConnection}.

*/
	public native int insertButton( QPixmap pixmap, int identifier, String signal, QObject receiver, String slot, boolean enabled, String text, int index);
	public native int insertButton( QPixmap pixmap, int identifier, String signal, QObject receiver, String slot);

/** 
 Inserts a button with popupmenu.

 Button will have small
 triangle. You have to connect to popup's signals. The
 signals {@link KButton#pressed}, {@link KButton#released},
 {@link KButton#clicked} or {@link KButton#doubleClicked} are <code>not</code>
 emmited by
 this button (see {@link #setDelayedPopup} for that).
 You can add custom popups which inherit {@link QPopupMenu} to get popups
 with tables, drawings etc. Just don't fiddle with events there.
   
*/
	public native int insertButton( String icon, int identifier, QPopupMenu popup, boolean enabled, String _text, int index);
	public native int insertButton( String icon, int identifier, QPopupMenu popup, boolean enabled, String _text);

/** 
 Inserts a button with popupmenu.

 Button will have small
 triangle. You have to connect to popup's signals. The
 signals {@link KButton#pressed}, {@link KButton#released},
 {@link KButton#clicked} or {@link KButton#doubleClicked} are <code>not</code>
 emmited by
 this button (see {@link #setDelayedPopup} for that).
 You can add custom popups which inherit {@link QPopupMenu} to get popups
 with tables, drawings etc. Just don't fiddle with events there.
   
*/
	public native int insertButton( QPixmap pixmap, int identifier, QPopupMenu popup, boolean enabled, String _text, int index);
	public native int insertButton( QPixmap pixmap, int identifier, QPopupMenu popup, boolean enabled, String _text);

/** 
 Inserts a {@link KLineEdit}. You have to specify signals and slots to
 which KLineEdit will be connected. KLineEdit has all slots QLineEdit
 has, plus signals {@link KLineEdit#completion} and {@link KLineEdit#textRotation}
 KLineEdit can be set to autoresize itself to full free width
 in toolbar, that is to last right aligned item. For that,
 toolbar must be set to full width (which it is by default).

*/
	public native int insertLined( String text, int identifier, String signal, QObject receiver, String slot, boolean enabled, String toolTipText, int size, int index);
	public native int insertLined( String text, int identifier, String signal, QObject receiver, String slot);

/** 
 Inserts a {@link KComboBox} with list.

 Can be writable, but cannot contain
 pixmaps. By default inserting policy is AtBottom, i.e. typed items
 are placed at the bottom of the list. Can be autosized. If the size
 argument is specified as -1, the width of the combobox is automatically
 computed.

*/
//	public native int insertCombo( String[] list, int identifier, boolean writable, String signal, QObject receiver, String slot, boolean enabled, String tooltiptext, int size, int index, int policy);
//	public native int insertCombo( String[] list, int identifier, boolean writable, String signal, QObject receiver, String slot);

/** 
 Insert a {@link KComboBox} with text.

  The rest is the same as above.

*/
	public native int insertCombo( String text, int identifier, boolean writable, String signal, QObject recevier, String slot, boolean enabled, String tooltiptext, int size, int index, int policy);
	public native int insertCombo( String text, int identifier, boolean writable, String signal, QObject recevier, String slot);

/** 
 Inserts a separator into the toolbar with the given id.
 Returns the separator's index
     
*/
	public native int insertSeparator( int index, int identifier);
	public native int insertSeparator();

/** 
 Inserts a line separator into the toolbar with the given id.
 Returns the separator's index
     
*/
	public native int insertLineSeparator( int index, int identifier);
	public native int insertLineSeparator();

/** 
 Inserts a user-defined widget.  The widget <code>must</code> have this
 toolbar as its parent.

 Widget must have a QWidget for base class.  Widget can be
 autosized to full width. If you forget about it, you can get a
 pointer to this widget with {@link #getWidget}.

*/
	public native int insertWidget( int identifier, int width, QWidget _widget, int index);
	public native int insertWidget( int identifier, int width, QWidget _widget);

/** 
 Inserts an animated widget.  A {@link KAnimWidget} will be created
 internally using the icon name you provide.
 This will emit a signal (clicked()) whenever the
 animation widget is clicked.

*/
	public native int insertAnimatedWidget( int identifier, QObject receiver, String slot, String icons, int index);
	public native int insertAnimatedWidget( int identifier, QObject receiver, String slot, String icons);

/** 
 This will return a pointer to the given animated widget, if it
 exists.

*/
	public native KAnimWidget animatedWidget( int identifier);

/** 
 Adds connections to items.

 It is important that you
 know the <code>id</code> of particular item. Nothing happens if you forget <code>id.</code>
   
*/
	public native void addConnection( int identifier, String signal, QObject receiver, String slot);

/** 
 Enables/disables item.
   
*/
	public native void setItemEnabled( int identifier, boolean enabled);

/** 
 Sets the icon for a button.

 Can be used while button is visible.
   
*/
	public native void setButtonIcon( int identifier, String _icon);

/** 
 Sets button pixmap.

 Can be used while button is visible.
   
*/
	public native void setButtonPixmap( int identifier, QPixmap _pixmap);

/** 
 Sets a button icon from a QIconSet.

 Can be used while button is visible.
   
*/
	public native void setButtonIconSet( int identifier, QIconSet iconset);

/** 
 Sets a delayed popup for a button.

 Delayed popup is what you see in
 Netscape Navigator's Previous and Next buttons: If you click them you
 go back
 or forth. If you press them long enough, you get a history-menu.
 This is exactly what we do here.

 You will insert normal a button with connection (or use signals from
 toolbar):
 <pre>
 bar.insertButton(icon, id, SIGNAL("clicked ()"), this,
                   SLOT (slotClick()), true, "click or wait for popup");
 </pre> And then add a delayed popup:
 <pre>
 bar.setDelayedPopup (id, historyPopup); </pre>

 Don't add delayed popups to buttons which have normal popups.

 You may add popups which are derived from {@link QPopupMenu}. You may
 add popups that are already in the menu bar or are submenus of
 other popups.
   
*/
	public native void setDelayedPopup( int identifier, QPopupMenu _popup, boolean toggle);
	public native void setDelayedPopup( int identifier, QPopupMenu _popup);

/** 
 Turns a button into an autorepeat button.

 Toggle buttons, buttons with menus, or
 buttons with delayed menus cannot be made into autorepeat buttons.
 Moreover, you can and will receive
 only the signal clicked(), but not pressed() or released().
 When the user presses this button, you will receive the signal clicked(),
 and if the button is still pressed after some time,
 you will receive more clicked() signals separated by regular
 intervals.  Since this uses {@link QButton#setAutoRepeat} ,
 I can't quantify 'some'.
   
*/
	public native void setAutoRepeat( int identifier, boolean flag);
	public native void setAutoRepeat( int identifier);

/** 
 Turns button into a toggle button if <code>flag</code> is true.
   
*/
	public native void setToggle( int identifier, boolean flag);
	public native void setToggle( int identifier);

/** 
 Toggles a togglebutton.

 If the button is a toggle button  (see {@link #setToggle})
 the button state will be toggled. This will also cause the toolbar to
 emit the signal {@link KButton#toggled} with parameter <code>id.</code> You must connect to
 this signal, or use {@link #addConnection} to connect directly to the
 button signal {@link KButton#toggled}.
   
*/
	public native void toggleButton( int identifier);

/** 
 Sets a toggle button state.

 If the button is a toggle button (see {@link #setToggle})
 this will set its state flag. This will also emit the signal
 {@link KButton#toggled}.

*/
	public native void setButton( int identifier, boolean flag);

/** 

*/
	public native boolean isButtonOn( int identifier);

/** 
 Sets the text of a line editor.

 Cursor is set at end of text.
   
*/
	public native void setLinedText( int identifier, String text);

/** 
 Returns a line editor text.
   
*/
	public native String getLinedText( int identifier);

/** 
 Inserts <code>text</code> in combobox <code>id</code> at position <code>index.</code>
   
*/
	public native void insertComboItem( int identifier, String text, int index);

/** 
 Inserts <code>list</code> in combobox <code>id</code> at position <code>index.</code>
   
*/
//	public native void insertComboList( int identifier, String[] list, int index);

/** 
 Removes item <code>index</code> from combobox <code>id.</code>
   
*/
	public native void removeComboItem( int identifier, int index);

/** 
 Sets item <code>index</code> to be current item in combobox <code>id.</code>
   
*/
	public native void setCurrentComboItem( int identifier, int index);

/** 
 Changes item <code>index</code> in combobox <code>id</code> to text.

 <code>index</code> = -1 refers current item (one displayed in the button).
   
*/
	public native void changeComboItem( int identifier, String text, int index);
	public native void changeComboItem( int identifier, String text);

/** 
 Clears the combobox <code>id.</code>

 Does not delete it or hide it.
   
*/
	public native void clearCombo( int identifier);

/** 
 Returns text of item <code>index</code> from combobox <code>id.</code>

 <code>index</code> = -1 refers to current item.
   
*/
	public native String getComboItem( int identifier, int index);
	public native String getComboItem( int identifier);

/** 
 Returns a pointer to the combobox.

 Example:
 <pre>
 KComboBox combo = toolbar.getCombo(combo_id);
 </pre>
 That way you can get access to other public methods
 that {@link KComboBox} provides.
   
*/
	public native KComboBox getCombo( int identifier);

/** 
 Returns a pointer to KToolBarLined.

 Example:
 <pre>
 KLineEdit  lined = toolbar.getKTollBarLined(lined_id);
 </pre>
 That way you can get access to other public methods
 that {@link KLineEdit} provides. {@link KLineEdit} is the same thing
 as {@link QLineEdit} plus completion signals.
   
*/
	public native KLineEdit getLined( int identifier);

/** 
 Returns a pointer to KToolBarButton.

 Example:
 <pre>
 KToolBarButton  button = toolbar.getButton(button_id);
 </pre>
 That way you can get access to other public methods
 that {@link KToolBarButton} provides.

  Using this method is not recommended.
   
*/
	public native KToolBarButton getButton( int identifier);

/** 
 Align item to the right.

 This works only if toolbar is set to full width.

*/
	public native void alignItemRight( int identifier, boolean right);
	public native void alignItemRight( int identifier);

/** 
 Returns a pointer to an inserted widget.

 Wrong ids are not tested.
 You can do with this whatever you want,
 except change its height (hardcoded). If you change its width
 you will probably have to call QToolBar.updateRects(true)

*/
	public native QWidget getWidget( int identifier);

/** 
 Set item autosized.

 This works only if the toolbar is set to full width.
 Only <code>one</code> item can be autosized, and it has to be
 the last left-aligned item. Items that come after this must be right
 aligned. Items that can be right aligned are Lineds, Frames, Widgets and
 Combos. An autosized item will resize itself whenever the toolbar geometry
 changes to the last right-aligned item (or to end of toolbar if there
 are no right-aligned items.)

*/
	public native void setItemAutoSized( int identifier, boolean yes);
	public native void setItemAutoSized( int identifier);

/** 
 Remove all items.

 The toolbar is redrawn after it.
   
*/
	public native void clear();

/** 
 Remove item <code>id.</code>

 Item is deleted. Toolbar is redrawn after it.
   
*/
	public native void removeItem( int identifier);

/** 
 Hide item.
   
*/
	public native void hideItem( int identifier);

/** 
 Show item.
   
*/
	public native void showItem( int identifier);

/** 
 Set toolbar to full parent size (default).

  In full size mode the bar
 extends over the parent's full width or height. If the mode is disabled
 the toolbar tries to take as much space as it needs without wrapping, but
 it does not exceed the parent box. You can force a certain width or
 height with {@link #setMaxWidth} or {@link #setMaxHeight}.

 If you want to use right-aligned items or auto-sized items you must use
 full size mode.
   
*/
	public native void setFullSize( boolean flag);
	public native void setFullSize();

/** 

*/
	public native boolean fullSize();

/** 

 Enable or disable moving of toolbar.
   
*/
	public native void enableMoving( boolean flag);
	public native void enableMoving();

/** 
 Set position of toolbar.

*/
	public native void setBarPos( int bpos);

/** 
 Returns position of toolbar.
   
*/
	public native int barPos();

/** 

 Show, hide, or toggle toolbar.

 This method is provided for compatibility only,
 please use show() and/or hide() instead.

*/
	public native boolean enable( int stat);

/** 

 Use setMaximumHeight() instead.
   
*/
	public native void setMaxHeight( int h);

/** 

 Use maximumHeight() instead.
 Returns the value that was set with {@link #setMaxHeight}.
   
*/
	public native int maxHeight();

/** 

 Use setMaximumWidth() instead.
 Set maximal width of horizontal (top or bottom) toolbar.
   
*/
	public native void setMaxWidth( int dw);

/** 

 Use maximumWidth() instead.
 Returns the value that was set with {@link #setMaxWidth}.
   
*/
	public native int maxWidth();

/** 
 Set title for toolbar when it floats.

 Titles are however not (yet)
 visible. You can't change toolbar's title while it's floating.
   
*/
	public native void setTitle( String _title);

/** 

 Use enableMoving() instead.
   
*/
	public native void enableFloating( boolean arrrrrrgh);

/** 
 Set the kind of painting for buttons.

 Choose from:

   
*/
	public native void setIconText( int it);

/** 
 Similar to {@link #setIconText} but allows you to
 disable or enable updating.  If <code>update</code> is false, then the
 buttons will not be updated.  This is useful only if you know
 that you will be forcing an update later.
   
*/
	public native void setIconText( int it, boolean update);

/** 

*/
	public native int iconTextId();

/** 
 Set the icon size to load. Usually you should not call
 this, the icon size is taken care of by KIconLoader
 and globally configured.
 By default, the toolbar will load icons of size 32 for main
 toolbars and 22 for other toolbars

*/
	public native void setIconSize( int size);

/** 
 Same as {@link #setIconText} but allows you
 to disable the toolbar update.

*/
	public native void setIconSize( int size, boolean update);

/** 

*/
	public native int iconSize();

/** 
 This allows you to enable or disable the context menu.

*/
	public native void setEnableContextMenu( boolean enable);
	public native void setEnableContextMenu();

/** 
 Returns whether or not the context menu is disabled

*/
	public native boolean contextMenuEnabled();

/** 
 This will inform a toolbar button to ignore certain style
 changes.  Specifically, it will ignore IconText (always IconOnly)
 and will not allow image effects to apply.

*/
	public native void setItemNoStyle( int identifier, boolean no_style);
	public native void setItemNoStyle( int identifier);
	public native void setFlat( boolean flag);

/** 

*/
	public native int count();

/** 
 Instruct the toolbar to save it's current state to either the app
 config file or to the XML-GUI resource file (whichever has
 precedence).
   
*/
	public native void saveState();

/** 
 Save the toolbar settings to group <code>configGroup</code> in <code>config.</code>
   
*/
	public native void saveSettings( KConfig config, String configGroup);

/** 
 Read the toolbar settings from group <code>configGroup</code> in <code>config</code>
 and apply them.
   
*/
	public native void applySettings( KConfig config, String configGroup);

/** 
 Tell the toolbar what XML-GUI resource file it should use to save
 it's state.  The state of the toolbar (position, size, etc) is
 saved in KConfig files if the application does not use XML-GUI..
 but if the app does, then it's saved the XML file.  This function
 allows this to happen.

*/
	public native void setXMLGUIClient( KXMLGUIClientInterface client);

/** 
 Assign a (translated) text to this toolbar. This is used
 for the tooltip on the handle, and when listing the toolbars.
   
*/
	public native void setText( String txt);

/** 

*/
	public native String text();
	public native void setStretchableWidget( QWidget w);
	public native QSizePolicy sizePolicy();
	public native boolean highlight();
	public native QSize sizeHint();
	public native QSize minimumSizeHint();
	public native QSize minimumSize();
	public native void hide();
	public native void show();
	public native void updateRects( boolean arg1);
	public native void updateRects();
	public native void loadState( QDomElement e);
	public native void saveState( QDomElement e);

/** 

     
*/
	public native void positionYourself( boolean force);
	public native void positionYourself();
	public native void setIconText( String txt);
	protected native void mousePressEvent( QMouseEvent arg1);
	protected native void childEvent( QChildEvent e);
	protected native void showEvent( QShowEvent e);
	protected native void resizeEvent( QResizeEvent e);
	public native boolean event( QEvent e);
	protected native void applyAppearanceSettings( KConfig config, String _configGroup, boolean forceGlobal);
	protected native void applyAppearanceSettings( KConfig config, String _configGroup);
	protected native String settingsGroup();
	protected native void virtual_hook( int identifier, int data);
	public static final int IconOnly = 0;
	public static final int IconTextRight = 0;
	public static final int TextOnly = 1;
	public static final int IconTextBottom = 2;
	public static final int Toggle = 0;
	public static final int Show = 1;
	public static final int Hide = 2;
	public static final int Unmanaged = 0;
	public static final int Floating = 1;
	public static final int Top = 2;
	public static final int Bottom = 3;
	public static final int Right = 4;
	public static final int Left = 5;
	public static final int Flat = 6;
}
