/***************************************************************************
                            KToolBar.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTOOLBAR_H
#define KTOOLBAR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QToolBar.h>

/**

 A KDE-style toolbar.

 KToolBar can be dragged around in and between different docks.

 A KToolBar can contain all sorts of widgets.

 KToolBar can be used as a standalone widget, but @ref KMainWindow
 provides easy factories and management of one or more toolbars.
 Once you have a KToolBar object, you can insert items into it with the
 insert... methods, or remove them with the @ref -removeItem method. This
 can be done at any time; the toolbar will be automatically updated.
 There are also many methods to set per-child properties like alignment
 and toggle behaviour.

 KToolBar uses a global config group to load toolbar settings on
 construction. It will reread this config group on a
 @ref -[KApplication appearanceChanged] signal.

 @author Reginald Stadlbauer <reggie@kde.org>, Stephan Kulow <coolo@kde.org>, Sven Radej <radej@kde.org>.
  
 @version $Id: KToolBar.h,v 1.3 2002/03/15 02:12:24 rdale Exp $

 @short Floatable toolbar with auto resize.

*/
@class KAnimWidget; 
@class KComboBox; 
@class KConfig; 
@class KInstance; 
@class KLineEdit; 
@class KToolBarButton; 
@class KXMLGUIClient; 
@class QDomElement; 
@class QIconSet; 
@class QPopupMenu; 

@interface KToolBar : QToolBar 

/** 
 Constructor.
 This constructor is used by the XML-GUI. If you use it, you need
 to call -[QMainWindow addToolBar]to specify the position of the toolbar.
 So it's simpler to use the other constructor.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref  #-_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name honor_style: (BOOL)honor_style readConfig: (BOOL)readConfig;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref  #-_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
- initWithMainWindow: (QMainWindow*)parentWindow dock: (int)dock newLine: (BOOL)newLine name: (NSString *)name honor_style: (BOOL)honor_style readConfig: (BOOL)readConfig;
- initWithMainWindow: (QMainWindow*)parentWindow dock: (int)dock ;

/** 
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref  #-_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
- initWithMainWindow: (QMainWindow*)parentWindow dockWidget: (QWidget *)dock newLine: (BOOL)newLine name: (NSString *)name honor_style: (BOOL)honor_style readConfig: (BOOL)readConfig;
- initWithMainWindow: (QMainWindow*)parentWindow dockWidget: (QWidget *)dock ;
- (void) dealloc;

/** 
 Insert a button (a @ref KToolBarButton) with a pixmap.  The
 pixmap is loaded by the button itself based on the global icon
 settings.

 You should connect to one or more signals in KToolBar:
 @ref -clicked , @ref -pressed , @ref -released , or
 @ref -highlighted  and if the button is a toggle button
 (@ref -setToggle ) @ref -toggled .  Those signals have @p id
 of a button that caused the signal.  If you want to bind a popup
 to button, see @ref -setButton.

*/
- (int) insertButton: (NSString *)icon identifier: (int)identifier enabled: (BOOL)enabled text: (NSString *)text index: (int)index _instance: (KInstance*)_instance;
- (int) insertButton: (NSString *)icon identifier: (int)identifier ;

/** 
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with @ref -addConnection.

*/
- (int) insertButton: (NSString *)icon identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot enabled: (BOOL)enabled text: (NSString *)text index: (int)index _instance: (KInstance*)_instance;
- (int) insertButton: (NSString *)icon identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Inserts a button (a @ref KToolBarButton) with the specified
 pixmap.  This pixmap will be used as the "active" one and the
 disabled and default ones will be autogenerated.

 It is recommended that you use the insertButton function that
 allows you to specify the icon name rather then the pixmap
 itself.  Specifying the icon name is much more flexible.

 You should connect to one or more signals in KToolBar:
 @ref -clicked , @ref -pressed , @ref -released , or
 @ref -highlighted  and if the button is a toggle button
 (@ref -setToggle ) @ref -toggled .  Those signals have @p id
 of a button that caused the signal.  If you want to bind a popup
 to button, see @ref -setButton.

*/
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier enabled: (BOOL)enabled text: (NSString *)text index: (int)index;
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier ;

/** 
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with @ref -addConnection.

*/
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot enabled: (BOOL)enabled text: (NSString *)text index: (int)index;
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Inserts a button with popupmenu.

 Button will have small
 triangle. You have to connect to popup's signals. The
 signals @ref -[KButton pressed], @ref -[KButton released],
 @ref -[KButton clicked] or @ref -[KButton doubleClicked] are @p not
 emmited by
 this button (see @ref -setDelayedPopup for that).
 You can add custom popups which inherit @ref QPopupMenu to get popups
 with tables, drawings etc. Just don't fiddle with events there.
   
*/
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier popup: (QPopupMenu*)popup enabled: (BOOL)enabled text: (NSString *)_text index: (int)index;
- (int) insertButtonWithPixmap: (QPixmap *)pixmap identifier: (int)identifier popup: (QPopupMenu*)popup enabled: (BOOL)enabled text: (NSString *)_text ;

/** 
 Inserts a @ref KLineEdit. You have to specify signals and slots to
 which KLineEdit will be connected. KLineEdit has all slots QLineEdit
 has, plus signals @ref -[KLineEdit completion]and @ref -[KLineEdit textRotation]KLineEdit can be set to autoresize itself to full free width
 in toolbar, that is to last right aligned item. For that,
 toolbar must be set to full width (which it is by default).

*/
- (int) insertLined: (NSString *)text identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot enabled: (BOOL)enabled toolTipText: (NSString *)toolTipText size: (int)size index: (int)index;
- (int) insertLined: (NSString *)text identifier: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Inserts a @ref KComboBox with list.

 Can be writable, but cannot contain
 pixmaps. By default inserting policy is AtBottom, i.e. typed items
 are placed at the bottom of the list. Can be autosized. If the size
 argument is specified as -1, the width of the combobox is automatically
 computed.

*/
- (int) insertCombo: (NSArray *)list identifier: (int)identifier writable: (BOOL)writable signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot enabled: (BOOL)enabled tooltiptext: (NSString *)tooltiptext size: (int)size index: (int)index policy: (int)policy;
- (int) insertCombo: (NSArray *)list identifier: (int)identifier writable: (BOOL)writable signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot ;

/** 
 Insert a @ref KComboBox with text.

  The rest is the same as above.

*/
- (int) insertCombo: (NSString *)text identifier: (int)identifier writable: (BOOL)writable signal: (NSString *)signal recevier: (QObject *)recevier slot: (NSString *)slot enabled: (BOOL)enabled tooltiptext: (NSString *)tooltiptext size: (int)size index: (int)index policy: (int)policy;
- (int) insertCombo: (NSString *)text identifier: (int)identifier writable: (BOOL)writable signal: (NSString *)signal recevier: (QObject *)recevier slot: (NSString *)slot ;

/** 
 Inserts a separator into the toolbar with the given id.
 Returns the separator's index
     
*/
- (int) insertSeparator: (int)index identifier: (int)identifier;
- (int) insertSeparator;

/** 
 Inserts a line separator into the toolbar with the given id.
 Returns the separator's index
     
*/
- (int) insertLineSeparator: (int)index identifier: (int)identifier;
- (int) insertLineSeparator;

/** 
 Inserts a user-defined widget.  The widget @p must have this
 toolbar as its parent.

 Widget must have a QWidget for base class.  Widget can be
 autosized to full width. If you forget about it, you can get a
 pointer to this widget with @ref -getWidget.

*/
- (int) insertWidget: (int)identifier width: (int)width _widget: (QWidget *)_widget index: (int)index;
- (int) insertWidget: (int)identifier width: (int)width _widget: (QWidget *)_widget ;

/** 
 Inserts an animated widget.  A @ref KAnimWidget will be created
 internally using the icon name you provide.
 This will emit a signal (-clicked) whenever the
 animation widget is clicked.

*/
- (int) insertAnimatedWidget: (int)identifier receiver: (QObject *)receiver slot: (NSString *)slot icons: (NSString *)icons index: (int)index;
- (int) insertAnimatedWidget: (int)identifier receiver: (QObject *)receiver slot: (NSString *)slot icons: (NSString *)icons ;

/** 
 This will return a pointer to the given animated widget, if it
 exists.

*/
- (KAnimWidget*) animatedWidget: (int)identifier;

/** 
 Adds connections to items.

 It is important that you
 know the @p id of particular item. Nothing happens if you forget @p id.
   
*/
- addConnection: (int)identifier signal: (NSString *)signal receiver: (QObject *)receiver slot: (NSString *)slot;

/** 
 Enables/disables item.
   
*/
- setItemEnabled: (int)identifier enabled: (BOOL)enabled;

/** 
 Sets button pixmap.

 Can be used while button is visible.
   
*/
- setButtonPixmap: (int)identifier _pixmap: (QPixmap *)_pixmap;

/** 
 Sets the icon for a button.

 Can be used while button is visible.
   
*/
- setButtonIcon: (int)identifier _icon: (NSString *)_icon;

/** 
 Sets a button icon from a QIconSet.

 Can be used while button is visible.
   
*/
- setButtonIconSet: (int)identifier iconset: (QIconSet*)iconset;

/** 
 Sets a delayed popup for a button.

 Delayed popup is what you see in
 Netscape Navigator's Previous and Next buttons: If you click them you
 go back
 or forth. If you press them long enough, you get a history-menu.
 This is exactly what we do here.

 You will insert normal a button with connection (or use signals from
 toolbar):
 <pre>
 -[bar insertButton](pixmap, id, const SIGNAL(clicked ()), this,
                   SLOT (-slotClick), true, "click or wait for popup");
 </pre> And then add a delayed popup:
 <pre>
 -[bar setDelayedPopup](id, historyPopup); </pre>

 Don't add delayed popups to buttons which have normal popups.

 You may add popups which are derived from @ref QPopupMenu. You may
 add popups that are already in the menu bar or are submenus of
 other popups.
   
*/
- setDelayedPopup: (int)identifier _popup: (QPopupMenu*)_popup toggle: (BOOL)toggle;
- setDelayedPopup: (int)identifier _popup: (QPopupMenu*)_popup ;

/** 
 Turns a button into an autorepeat button.

 Toggle buttons, buttons with menus, or
 buttons with delayed menus cannot be made into autorepeat buttons.
 Moreover, you can and will receive
 only the signal -clicked, but not -pressed or -released.
 When the user presses this button, you will receive the signal -clicked,
 and if the button is still pressed after some time,
 you will receive more -clicked signals separated by regular
 intervals.  Since this uses @ref -[QButton setAutoRepeat] ,
 I can't quantify 'some'.
   
*/
- setAutoRepeat: (int)identifier flag: (BOOL)flag;
- setAutoRepeat: (int)identifier ;

/** 
 Turns button into a toggle button if @p flag is true.
   
*/
- setToggle: (int)identifier flag: (BOOL)flag;
- setToggle: (int)identifier ;

/** 
 Toggles a togglebutton.

 If the button is a toggle button  (see @ref -setToggle)
 the button state will be toggled. This will also cause the toolbar to
 emit the signal @ref -[KButton toggled] with parameter @p id. You must connect to
 this signal, or use @ref -addConnection to connect directly to the
 button signal @ref -[KButton toggled].
   
*/
- toggleButton: (int)identifier;

/** 
 Sets a toggle button state.

 If the button is a toggle button (see @ref -setToggle)
 this will set its state flag. This will also emit the signal
 @ref -[KButton toggled].

*/
- setButton: (int)identifier flag: (BOOL)flag;

/** 

*/
- (BOOL) isButtonOn: (int)identifier;

/** 
 Sets the text of a line editor.

 Cursor is set at end of text.
   
*/
- setLinedText: (int)identifier text: (NSString *)text;

/** 
 Returns a line editor text.
   
*/
- (NSString *) getLinedText: (int)identifier;

/** 
 Inserts @p text in combobox @p id at position @p index.
   
*/
- insertComboItem: (int)identifier text: (NSString *)text index: (int)index;

/** 
 Inserts @p list in combobox @p id at position @p index.
   
*/
- insertComboList: (int)identifier list: (NSArray *)list index: (int)index;

/** 
 Removes item @p index from combobox @p id.
   
*/
- removeComboItem: (int)identifier index: (int)index;

/** 
 Sets item @p index to be current item in combobox @p id.
   
*/
- setCurrentComboItem: (int)identifier index: (int)index;

/** 
 Changes item @p index in combobox @p id to text.

 @p index = -1 refers current item (one displayed in the button).
   
*/
- changeComboItem: (int)identifier text: (NSString *)text index: (int)index;
- changeComboItem: (int)identifier text: (NSString *)text ;

/** 
 Clears the combobox @p id.

 Does not delete it or hide it.
   
*/
- clearCombo: (int)identifier;

/** 
 Returns text of item @p index from combobox @p id.

 @p index = -1 refers to current item.
   
*/
- (NSString *) getComboItem: (int)identifier index: (int)index;

/** 
 Returns a pointer to the combobox.

 Example:
 <pre>
 KComboBox *combo = -[toolbar getCombo];
 </pre>
 That way you can get access to other public methods
 that @ref KComboBox provides.
   
*/
- (KComboBox*) getCombo: (int)identifier;

/** 
 Returns a pointer to KToolBarLined.

 Example:
 <pre>
 KLineEdit * lined = -[toolbar getKTollBarLined];
 </pre>
 That way you can get access to other public methods
 that @ref KLineEdit provides. @ref KLineEdit is the same thing
 as @ref QLineEdit plus completion signals.
   
*/
- (KLineEdit*) getLined: (int)identifier;

/** 
 Returns a pointer to KToolBarButton.

 Example:
 <pre>
 KToolBarButton * button = -[toolbar getButton];
 </pre>
 That way you can get access to other public methods
 that @ref KToolBarButton provides.

  Using this method is not recommended.
   
*/
- (KToolBarButton*) getButton: (int)identifier;

/** 
 Align item to the right.

 This works only if toolbar is set to full width.

*/
- alignItemRight: (int)identifier right: (BOOL)right;
- alignItemRight: (int)identifier ;

/** 
 Returns a pointer to an inserted widget.

 Wrong ids are not tested.
 You can do with this whatever you want,
 except change its height (hardcoded). If you change its width
 you will probably have to call -[QToolBar updateRects]

*/
- (QWidget*) getWidget: (int)identifier;

/** 
 Set item autosized.

 This works only if the toolbar is set to full width.
 Only @p one item can be autosized, and it has to be
 the last left-aligned item. Items that come after this must be right
 aligned. Items that can be right aligned are Lineds, Frames, Widgets and
 Combos. An autosized item will resize itself whenever the toolbar geometry
 changes to the last right-aligned item (or to end of toolbar if there
 are no right-aligned items.)

*/
- setItemAutoSized: (int)identifier yes: (BOOL)yes;
- setItemAutoSized: (int)identifier ;

/** 
 Remove all items.

 The toolbar is redrawn after it.
   
*/
- clear;

/** 
 Remove item @p id.

 Item is deleted. Toolbar is redrawn after it.
   
*/
- removeIntItem: (int)identifier;

/** 
 Hide item.
   
*/
- hideItem: (int)identifier;

/** 
 Show item.
   
*/
- showItem: (int)identifier;

/** 
 Set toolbar to full parent size (default).

  In full size mode the bar
 extends over the parent's full width or height. If the mode is disabled
 the toolbar tries to take as much space as it needs without wrapping, but
 it does not exceed the parent box. You can force a certain width or
 height with @ref -setMaxWidth or @ref -setMaxHeight.

 If you want to use right-aligned items or auto-sized items you must use
 full size mode.
   
*/
- setFullSize: (BOOL)flag;
- setFullSize;

/** 

*/
- (BOOL) fullSize;

/** 
 Enable or disable moving of toolbar.
   
*/
- enableMoving: (BOOL)flag;
- enableMoving;

/** 
 Set position of toolbar.

*/
- setBarPos: (int)bpos;

/** 
 Returns position of toolbar.
   
*/
- (int) barPos;

/** 

 Show, hide, or toggle toolbar.

 This method is provided for compatibility only,
 please use -show and/or -hide instead.

*/
- (BOOL) enable: (int)stat;

/** 

 Use -setMaximumHeight instead.
   
*/
- setMaxHeight: (int)h;

/** 

 Use -maximumHeight instead.
 Returns the value that was set with @ref -setMaxHeight.
   
*/
- (int) maxHeight;

/** 

 Use -setMaximumWidth instead.
 Set maximal width of horizontal (top or bottom) toolbar.
   
*/
- setMaxWidth: (int)dw;

/** 

 Use -maximumWidth instead.
 Returns the value that was set with @ref -setMaxWidth.
   
*/
- (int) maxWidth;

/** 
 Set title for toolbar when it floats.

 Titles are however not (yet)
 visible. You can't change toolbar's title while it's floating.
   
*/
- setTitle: (NSString *)_title;

/** 

 Use -enableMoving instead.
   
*/
- enableFloating: (BOOL)arrrrrrgh;

/** 
 Set the kind of painting for buttons.

 Choose from:

   
*/
- setIconTextWithId: (int)it;

/** 
 Similar to @ref setIconText(IconText it) but allows you to
 disable or enable updating.  If @p update is false, then the
 buttons will not be updated.  This is useful only if you know
 that you will be forcing an update later.
   
*/
- setIconTextWithId: (int)it update: (BOOL)update;

/** 

*/
- (int) iconText;

/** 
 Set the icon size to load. Usually you should not call
 this, the icon size is taken care of by KIconLoader
 and globally configured.
 By default, the toolbar will load icons of size 32 for main
 toolbars and 22 for other toolbars

*/
- setIconSize: (int)size;

/** 
 Same as @ref setIconText(int size) but allows you
 to disable the toolbar update.

*/
- setIconSize: (int)size update: (BOOL)update;

/** 

*/
- (int) iconSize;

/** 
 This allows you to enable or disable the context menu.

*/
- setEnableContextMenu: (BOOL)enable;
- setEnableContextMenu;

/** 
 Returns whether or not the context menu is disabled

*/
- (BOOL) contextMenuEnabled;

/** 
 This will inform a toolbar button to ignore certain style
 changes.  Specifically, it will ignore IconText (always IconOnly)
 and will not allow image effects to apply.

*/
- setItemNoStyle: (int)identifier no_style: (BOOL)no_style;
- setItemNoStyle: (int)identifier ;
- setFlat: (BOOL)flag;

/** 

*/
- (int) count;

/** 
 Instruct the toolbar to save it's current state to either the app
 config file or to the XML-GUI resource file (whichever has
 precedence).
   
*/
- saveState;

/** 
 Save the toolbar settings to group @p configGroup in @p config.
   
*/
- saveSettings: (KConfig*)config configGroup: (NSString *)configGroup;

/** 
 Read the toolbar settings from group @p configGroup in @p config
 and apply them.
   
*/
- applySettings: (KConfig*)config configGroup: (NSString *)configGroup;

/** 
 Tell the toolbar what XML-GUI resource file it should use to save
 it's state.  The state of the toolbar (position, size, etc) is
 saved in KConfig files if the application does not use XML-GUI..
 but if the app does, then it's saved the XML file.  This function
 allows this to happen.

*/
- setXMLGUIClient: (KXMLGUIClient*)client;

/** 
 Assign a (translated) text to this toolbar. This is used
 for the tooltip on the handle, and when listing the toolbars.
   
*/
- setText: (NSString *)txt;

/** 

*/
- (NSString *) text;
- setStretchableWidget: (QWidget *)w;
- (QSizePolicy*) sizePolicy;
- (BOOL) highlight;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- (QSize*) minimumSize;
- hide;
- show;
- updateRects: (BOOL)arg1;
- updateRects;
- loadState: (QDomElement*)e;
- saveState: (QDomElement*)e;

/** 

     
*/
- positionYourself: (BOOL)force;
- positionYourself;
- setIconText: (NSString *)txt;
- (BOOL) event: (QEvent *)e;
- applyAppearanceSettings: (KConfig*)config _configGroup: (NSString *)_configGroup forceGlobal: (BOOL)forceGlobal;
- applyAppearanceSettings: (KConfig*)config _configGroup: (NSString *)_configGroup ;
- (NSString *) settingsGroup;
+ (int) IconOnly;
+ (int) IconTextRight;
+ (int) TextOnly;
+ (int) IconTextBottom;
+ (int) Toggle;
+ (int) Show;
+ (int) Hide;
+ (int) Unmanaged;
+ (int) Floating;
+ (int) Top;
+ (int) Bottom;
+ (int) Right;
+ (int) Left;
+ (int) Flat;
@end

/** Override these methods in subclasses of KToolBar to customise event handling behaviour */
@protocol KToolBarEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) e;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) e;
- contextMenuEvent:(QContextMenuEvent*) e;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
