/***************************************************************************
                            KXMLGUIBuilder.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLGUIBUILDER_H
#define KXMLGUIBUILDER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 Abstract interface for a "GUI builder", used by the GUIFactory
 This interface is implemented by @ref MainWindow for the case where
 the toplevel widget is a KMainWindow. Other implementations may appear
 in the future (dialogs for instance)
 
 @short 

*/

@class KInstance;
@class KXMLGUIClient;
@class QDomElement;
@class QWidget;

@protocol KXMLGUIBuilderInterface
- (KXMLGUIClient*) builderClient;
- setBuilderClient: (KXMLGUIClient*)client;
- (KInstance*) builderInstance;
- setBuilderInstance: (KInstance*)instance;
- (NSArray *) containerTags;

/** 
 Creates a container (menubar/menu/toolbar/statusbar/separator/...)
 from an element in the XML file

*/
- (QWidget*) createContainer: (QWidget *)parent index: (int)index element: (QDomElement*)element identifier: (int)identifier;

/** 
 Removes the given (and previously via @ref createContainer )
 created container.

*/
- removeContainer: (QWidget *)container parent: (QWidget *)parent element: (QDomElement*)element identifier: (int)identifier;
- (NSArray *) customTags;
- (int) createCustomElement: (QWidget *)parent index: (int)index element: (QDomElement*)element;
- removeCustomElement: (QWidget *)parent identifier: (int)identifier;
- finalizeXMLGUI: (KXMLGUIClient*)client;
@end

@interface KXMLGUIBuilder : NSObject <QtSupport,KXMLGUIBuilderInterface>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- initWithWidget: (QWidget *)widget;
- (void) dealloc;
@end

#endif
