/***************************************************************************
                          slope.cpp  -  description
                             -------------------
    begin                : Tue Jul 31 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "slope.h"

Slope::Slope()
{
	ID = ID_slope;
  identificator = "Slope";

	int temp[] = { ID_geoPoint, 2, -1, ID_geoLine, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
	pic = QPixmap( UserIcon( "slope" ) );
	picRect  = QRect( 1, 2, 22, 20 );
}

Slope::~Slope()
{
}

void Slope::move()
{
	Coordinates coord1, coord2, coord3, coord4;

	if ( isGeoLine( parents.at( 0 ) ) )
	{
		coord1 = parents.at( 0 )->getStartCoordinates();
		coord2 = parents.at( 0 )->getEndCoordinates();
	}
  else
	{
		coord1 = parents.at( 0 )->getCoordinates();
		coord2 = parents.at( 1 )->getCoordinates();
	}

	// Figure out anchorPoint.
  coord3 = coord1 - coord2;
	coord3 /= 2;
	coord3 += coord2;

	anchorPoint = QPoint( coord3.getI_X(), coord3.getI_Y() );

	MetricsCenter::mapCanvasToGrid( coord1 );
	MetricsCenter::mapCanvasToGrid( coord2 );

	// Calculate distance and store it in value.
	double dx = coord1.getD_X() - coord2.getD_X();
	double dy = coord1.getD_Y() - coord2.getD_Y();

	if ( dx != 0 )
	{
		double myValue = ( dy / dx );
		if ( myValue == 0 )
		{
			myValue = 0;
		}
	  value = QString().setNum( myValue,'f',4 );
	}
	else
	{
		value = "<inf>";
	}

	if ( textRect.height() == 0 )
	{
		textRect = QRect( 0, 0, 0, 22 );
  	textRect.moveCenter( anchorPoint );
	}

	coords = Coordinates( textRect.center() );
}
