/***************************************************************************
                          circle.h  -  description
                             -------------------
    begin                : Mon Mar 27 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CIRCLE_H
#define CIRCLE_H

#include <geoobjects.h>

/**This class represents a circle.
  *@author Marc Bartsch
  */

class Circle : public GeoObjects
{
	public:

		Circle();
		virtual ~Circle();

		virtual void		getObjectOverlay( QList <QRect> & list );

	  virtual void 		paint( QPainter *p );
	  virtual bool		contains( QPoint *pt );

		virtual void 		move();
		virtual void 		moveMe( Coordinates & coords );
		virtual void 		moveMe( Coordinates & coords, double position );
		virtual double	positionMe( Coordinates & coords );

		virtual void 		writeToFile( KSimpleConfig *config );
		virtual void 		readFromFile( KSimpleConfig *config );
};

#endif


