/*
 * This file is part of the html renderer for KDE.
 *
 * Copyright (C) 2001 Antti Koivisto (koivisto@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: render_container.h,v 1.7 2002/09/18 14:49:57 knoll Exp $
 */
#ifndef render_container_h
#define render_container_h

#include "render_object.h"

namespace khtml
{


/**
 * Base class for rendering objects that can have children
 */
class RenderContainer : public RenderObject
{
public:
    RenderContainer(DOM::NodeImpl* node);
    virtual ~RenderContainer();

    RenderObject *firstChild() const { return m_first; }
    RenderObject *lastChild() const { return m_last; }

    virtual void addChild(RenderObject *newChild, RenderObject *beforeChild = 0);

    virtual RenderObject* removeChildNode(RenderObject* child);
    virtual void appendChildNode(RenderObject* child);
    virtual void insertChildNode(RenderObject* child, RenderObject* before);

    virtual void layout();
    virtual void calcMinMaxWidth() { setMinMaxKnown( true ); }

    virtual void removeLeftoverAnonymousBoxes();

private:

    void setFirstChild(RenderObject *first) { m_first = first; }
    void setLastChild(RenderObject *last) { m_last = last; }

protected:

    void insertPseudoChild(RenderStyle::PseudoId type, RenderObject* child, RenderObject* before);

    RenderObject *m_first;
    RenderObject *m_last;
};
};
#endif
