/*
   This file is part of KDE/aRts (Noatun) - xine integration
   Copyright (C) 2002 Ewald Snel <ewald@rambo.its.tudelft.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
*/

#ifndef __XINEPLAYOBJECT_IMPL_H
#define __XINEPLAYOBJECT_IMPL_H

#include <string>
#include <pthread.h>
#include <stdsynthmodule.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <xine.h>
#include <xine/video_out_x11.h>
#include "audio_fifo_out.h"
#include "video_fifo_out.h"
#include "xinePlayObject.h"


using namespace std;
using Arts::poState;
using Arts::poTime;
using Arts::poCapabilities;

class xinePlayObject_impl : public xinePlayObject_skel, public Arts::StdSynthModule
{
public:
    xinePlayObject_impl();
    virtual ~xinePlayObject_impl();

    bool loadMedia( const string &filename );
    string description();
    poTime currentTime();
    poTime overallTime();
    poCapabilities capabilities();
    string mediaName();
    poState state();
    bool snapshot( long pixmap );
    long x11Snapshot();
    long x11WindowId();
    void x11WindowId( long window );
    void play();
    void halt();
    void seek( const class poTime &t );
    void pause();
    void calculateBlock( unsigned long samples );

protected:
    void playEvent();
    void stopEvent();
    void xineEvent( xine_event_t *event );
    void sendEvent( long window, long message );
    void clearWindow();
    void eventLoop();

    // C -> C++ wrapper for pthread API
    static inline void *pthread_start_routine( void *arg )
    {
	((xinePlayObject_impl *)arg)->eventLoop();
	pthread_exit( 0 );
    }

    // C -> C++ wrapper for xine API
    static inline void xine_handle_event( void *user_data, xine_event_t *event )
    {
	((xinePlayObject_impl *)user_data)->xineEvent( event );
    }

private:
    double	     flpos;
    string	     mrl;
    bool	     running;

    pthread_mutex_t  mutex;
    pthread_cond_t   cond;
    pthread_t	     thread;

    config_values_t *config;
    xine_t	    *xine;
    ao_driver_t	    *ao_driver;
    vo_driver_t	    *vo_driver;
    xine_arts_audio  audio;
    xine_arts_video  video;
};

#endif
