/*
 * battery.cpp
 *
 * Copyright (c) 2002 Paul Campbell <paul@taniwha.com>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "acpi_config.h"
#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <stdio.h>
#include <stdlib.h>


acpi_config::acpi_config(QWidget *parent, KConfig *config, QVBoxLayout *layout)
{
	QHBoxLayout *l = new QHBoxLayout(parent);
	saved_config = config;
	QPushButton *button = new QPushButton(i18n("Setup ACPI..."), parent);
	l->addWidget(button);
	l->addStretch(1);
	connect(button, SIGNAL(pressed()), this, SLOT(acpi_config_start()));
  	layout->addLayout(l);
	config->setGroup("ACPIConfig");
	acpi_sleep = config->readEntry("SleepText", "how to standby");
	acpi_sleep_enabled = config->readBoolEntry("SleepEnabled", false);
	acpi_suspend = config->readEntry("SuspendText", "how to suspend");
	acpi_suspend_enabled = config->readBoolEntry("SuspendEnabled", false);
	acpi_hibernate = config->readEntry("HibernateText", "how to hibernate");
	acpi_hibernate_enabled = config->readBoolEntry("HibernateEnabled", false);
}

acpi_config::acpi_config(KConfig *config)
{
	saved_config = 0;
	config->setGroup("ACPIConfig");
	acpi_sleep = config->readEntry("SleepText", "how to standby");
	acpi_sleep_enabled = config->readBoolEntry("SleepEnabled", false);
	acpi_suspend = config->readEntry("SuspendText", "how to suspend");
	acpi_suspend_enabled = config->readBoolEntry("SuspendEnabled", false);
	acpi_hibernate = config->readEntry("HibernateText", "how to hibernate");
	acpi_hibernate_enabled = config->readBoolEntry("HibernateEnabled", false);
}

acpi_config::~acpi_config()
{
}

void
acpi_config::do_command(QString &cmd)
{
	::system(cmd.latin1());
}

void
acpi_config::acpi_config_start()
{
	if (saved_config == 0)
		return;
	acpi_dialog d(saved_config, acpi_sleep_enabled, acpi_sleep, 
		acpi_suspend_enabled, acpi_suspend,
		acpi_hibernate_enabled, acpi_hibernate);
	if (d.exec()) 
		d.Save(acpi_sleep_enabled, acpi_sleep,
                	acpi_suspend_enabled, acpi_suspend,
                	acpi_hibernate_enabled, acpi_hibernate);
}

acpi_dialog::acpi_dialog(KConfig *c, bool sleep_e, QString &sleep_t,
		bool suspend_e, QString &suspend_t,
		bool hibernate_e, QString &hibernate_t): KDialog(0, "", true)
{
	config = c;
	config->setGroup("ACPIConfig");
	changed = 0;
	setCaption(i18n("Configure ACPI Interface"));
    	QVBoxLayout *top_layout = new QVBoxLayout( this, KDialog::marginHint(),
                                               KDialog::spacingHint() );

	QLabel *warning = new QLabel( i18n("This panel allows you to use which commands your system uses for 'Standby' (temporary sleep), 'Suspend' (suspend-to-RAM) and 'Hibernate' (suspend-to-disk) since the Linux ACPI implentation is still a work in progress some or all of these commands may not work on your system, or even may cause it to crash or lose data. Please only enable the ones you are comfortable with"), this);
	warning->setAlignment(Qt::WordBreak| Qt::AlignAuto | Qt::AlignVCenter);
	warning->setMaximumWidth(300);
	top_layout->addWidget( warning);
	QGridLayout *grid = new QGridLayout( this, 3, 3, /* rows x cols */
                                         KDialog::marginHint(),
                                         KDialog::spacingHint() );

	grid->addWidget( new QLabel( i18n("Standby:"), this), 0, 0);
	sleep_enabled = new QCheckBox(this);
	grid->addWidget(sleep_enabled, 0, 1);
	sleep_edit = new KLineEdit(this);
	sleep_edit->setText(sleep_t);
	sleep_edit->setEnabled(sleep_e);
	sleep_enabled->setChecked(sleep_e);
	grid->addWidget(sleep_edit, 0, 2);
	connect(sleep_enabled, SIGNAL(clicked()), this, SLOT(configChanged()));
	connect(sleep_enabled, SIGNAL(toggled(bool)), sleep_edit, SLOT(setEnabled(bool)));
	connect(sleep_edit, SIGNAL(textChanged(const QString&)), this, SLOT(configChanged()));

	
	grid->addWidget( new QLabel( i18n("Suspend:"), this), 1, 0);
	suspend_enabled = new QCheckBox(this);
	grid->addWidget(suspend_enabled, 1, 1);
	suspend_edit = new KLineEdit(this);
	suspend_edit->setText(suspend_t);
	suspend_edit->setEnabled(suspend_e);
	grid->addWidget(suspend_edit, 1, 2);
	suspend_enabled->setChecked(suspend_e);
	connect(suspend_enabled, SIGNAL(clicked()), this, SLOT(configChanged()));
	connect(suspend_enabled, SIGNAL(toggled(bool)), suspend_edit, SLOT(setEnabled(bool)));
	connect(suspend_edit, SIGNAL(textChanged(const QString&)), this, SLOT(configChanged()));
	
	grid->addWidget( new QLabel( i18n("Hibernate:"), this), 2, 0);
	hibernate_enabled = new QCheckBox(this);
	grid->addWidget(hibernate_enabled, 2, 1);
	hibernate_edit = new KLineEdit(this);
	hibernate_edit->setText(hibernate_t);
	hibernate_edit->setEnabled(hibernate_e);
	hibernate_enabled->setChecked(hibernate_e);
	grid->addWidget(hibernate_edit, 2, 2);
	connect(hibernate_enabled, SIGNAL(clicked()), this, SLOT(configChanged()));
	connect(hibernate_enabled, SIGNAL(toggled(bool)), hibernate_edit, SLOT(setEnabled(bool)));
	connect(hibernate_edit, SIGNAL(textChanged(const QString&)), this, SLOT(configChanged()));
	top_layout->addLayout(grid);

	QHBoxLayout *layout = new QHBoxLayout( this );
	save_button = new QPushButton(i18n("&OK"), this);
	layout->addWidget(save_button);
	layout->addStretch(1);
	cancel_button = new QPushButton(i18n("&Cancel"), this);
	layout->addWidget(cancel_button);
	connect(save_button, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));
	top_layout->addLayout(layout);

	setMinimumSize( 300, 50 );
}

void
acpi_dialog::configChanged()
{
	changed = 1;
}

void
acpi_dialog::Save(bool &sleep_e, QString &sleep_t,
                  bool &suspend_e, QString &suspend_t,
                  bool &hibernate_e, QString &hibernate_t)
{
	if (changed) {
		config->setGroup("ACPIConfig");
		config->writeEntry("SleepText", sleep_t = sleep_edit->text());
		config->writeEntry("SleepEnabled", sleep_e = sleep_enabled->isChecked());
		config->writeEntry("SuspendText", suspend_t = suspend_edit->text());
		config->writeEntry("SuspendEnabled", suspend_e = suspend_enabled->isChecked());
		config->writeEntry("HibernateText", hibernate_t = hibernate_edit->text());
		config->writeEntry("HibernateEnabled", hibernate_e = hibernate_enabled->isChecked());
		config->sync();
	}
}

#include "acpi_config.moc"

