/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cmdhandler.h"

#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qtextstream.h>

#include <klocale.h>
#include <kapplication.h>

#include <themeloader.h>
#include <ksimconfig.h>
#include <common.h>

void printMessage(const QString &message)
{
  QTextStream sendMessage(stdout, IO_WriteOnly);
  sendMessage << message << endl;
}

KSim::CmdHandler::CmdHandler()
{
}

KSim::CmdHandler::~CmdHandler()
{
}

void KSim::CmdHandler::setThemeAlternatives(int alternative)
{
  m_themeAlt = alternative;
}

void KSim::CmdHandler::setConfigFileName(const QCString &name)
{
  m_themeFile = QFile::decodeName(name);
}

void KSim::CmdHandler::themeOption(const QCString &fileName)
{
  QString gkrellmName = QString::fromLatin1("gkrellmrc");
  gkrellmName += KSim::ThemeLoader::alternativeAsString(m_themeAlt);
  QFileInfo fileInfo(QFile::decodeName(fileName));
  QString absPath = fileInfo.absFilePath() + QString::fromLatin1("/");

  if (fileInfo.exists()) {
    if (QFile::exists(absPath + gkrellmName)) {
      QString dirName = fileInfo.dir(false).dirName();
      printMessage(i18n("Setting %1 as current theme").arg(dirName));
      KSim::Config configObject(kapp->config());
      configObject.setThemeName(dirName);
      configObject.setThemeAlt(m_themeAlt);
    }
    else
      printMessage(i18n("%1 does not contain a gkrellmrc file").arg(absPath));
  }
}

void KSim::CmdHandler::parseThemeOption(const QCString &fileName)
{
  QString dir(QFile::decodeName(fileName) + "/");
  if (QFile::exists(dir)) {
    /* change the dir structure */
    printMessage(i18n("parsing %1").arg(dir));
    KSim::ThemeLoader::self().parseDir(dir, m_themeAlt);
    if (m_themeFile.isNull() || m_themeFile.findRev("ksim") != -1)
      return;

    if (QFile::exists(dir + m_themeFile)) {
      printMessage(i18n("parsing file..."));
      QString parsedFile = KSim::ThemeLoader::self().parseConfig(dir, m_themeFile);
      printMessage(i18n("wrote file: %1").arg(parsedFile));
    }
    else
      printMessage(i18n("%1 is not a gkrellmrc file").arg(dir + m_themeFile));
  }
  else
    printMessage(i18n("%1 does not exist").arg(dir));
}
