#!/bin/sh 
#
###################################################################
# Program: trackbuild.php
# Purpose: Build a Slackware Package of PHP for UKShells
# Author : Stuart Winter <stuart@polplex.co.uk>
# Date...: 20/12/02
###################################################################

PACKAGE=php
VERSION=4.3.1
ARCH=i386
BUILD=1
SLACKPACKAGE="${PACKAGE}-${VERSION}-${ARCH}-${BUILD}.tgz"


# We do NOT want to ever build this package on a UKShells server
if [ ! -z "$( hostname --fqdn | grep ".ukshells.co.uk" )" ]; then
   echo "ERROR: You should NOT compile this package on a UKShells production server"
   echo "       You MUST compile this on a dev box"
   exit 1
fi

# Be careful here -- REALLY MAKE SURE YOU *ARE* on a devbox, else comment
# this line
removepkg php

# We cannot build if an existing version of the same package is already installed
# This is because slacktrack re-maps filesystem writes to a pseudo root file system
# rather than writing into the root file system.  This means that when packages such as
# Apache come to do install/update /www/conf/httpd.conf, they FIND the existing file,
# get the inode of that file and try to update it.  slacktrack re-maps the append
# write to /var/tmp/something/ and of course, Apache gets confused and breaks.
if [ -f /var/log/packages/${PACKAGE}* ]; then
   echo "${PACKAGE} SlackBuild ERROR"
   echo "Remove the existing version of the '${PACKAGE}' package first"
   exit 1
 else
  which slacktrack >/dev/null 2>&1 || { echo "slacktrack not installed.  Cannot build without it" ; exit 1 ;}
fi


# Ensure we can find sendmail otherwise php doesn't include the support for it!
# I mean, you can configure mail options in php.ini so why drop
# mail() JUST BECAUSE THERE'S NO MTA AT COMPILE TIME.   AGGR!
which sendmail >/dev/null 2>&1 || { echo "sendmail not installed; PHP build would be incomplete." ; exit 1 ;}

# Resting place for newly built Slackware packages
export BUILDSTORE=/tmp/built-slackwarepackages/not-for-distribution
mkdir -pm700 ${BUILDSTORE}

# We depend on the UKShells 'webservices' package being installed ( -d "webservices" )
# ** Note: We do NOT create ( --nocreatetgz ) the Slackware .tgz package yet.  This is because
#    I simply can't get PEAR modules (buildscripts/build.pear) to work under installwatch/slacktrack
#    I have tried EVERYTHING possible and it simply doesn't want to know, yet it works
#    fine if you don't run the script via installwatch.
#    We will run makepkg after slacktrack. **
slacktrack \
  --nocreatetgz               \
  --tempdir /var/tmp/phpbuild \
  -d "webservices"            \
  -b "${BUILDSTORE}"          \
  -fenSp "${SLACKPACKAGE}"    \
  "/bin/sh -x php.build"

if [ $? -gt 0 ]; then
   echo "Error: slacktrack exited with a value > 0"
   exit 1
fi

# Build PEAR modules.  Pass a couple of important environment variables to the
# script.
export BUILDPATH="/tmp/compiling-slackpacks/php"   ORIGPATH="$( pwd )"
export SLACKTRACKFAKEROOT=/var/tmp/phpbuild/TRANSL
buildscripts/build.pear

# Run the Slackware package maker
cd /var/tmp/phpbuild/TRANSL
makepkg -l y -c y ${BUILDSTORE}/${SLACKPACKAGE}

# Tidy up the temporary installwatch/slacktrack directory
rm -rf /var/tmp/phpbuild

# There's a ton of source & mess in here after we've compiled php and Apache
printf "\n\nCleaning up /tmp/compiling-slackpacks/\n\n"
rm -rf /tmp/compiling-slackpacks/

echo "** PHP trackbuild script complete."
echo "** You MUST check ${BUILDSTORE}/${SLACKPACKAGE}"
echo "** to ensure it's sensible before rolling it out"

#EOF
