/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%              PPPP    AAA   TTTTT  TTTTT  EEEEE  RRRR   N   N                %
%              P   P  A   A    T      T    E      R   R  NN  N                %
%              PPPP   AAAAA    T      T    EEE    RRRR   N N N                %
%              P      A   A    T      T    E      R R    N  NN                %
%              P      A   A    T      T    EEEEE  R  R   N   N                %
%                                                                             %
%                                                                             %
%                      Read/Write Pattern Image Format.                       %
%                                                                             %
%                              Software Design                                %
%                                John Cristy                                  %
%                                 May 2003                                    %
%                                                                             %
%                                                                             %
%  Copyright (C) 2003 ImageMagick Studio, a non-profit organization dedicated %
%  to making software imaging solutions freely available.                     %
%                                                                             %
%  Permission is hereby granted, free of charge, to any person obtaining a    %
%  copy of this software and associated documentation files ("ImageMagick"),  %
%  to deal in ImageMagick without restriction, including without limitation   %
%  the rights to use, copy, modify, merge, publish, distribute, sublicense,   %
%  and/or sell copies of ImageMagick, and to permit persons to whom the       %
%  ImageMagick is furnished to do so, subject to the following conditions:    %
%                                                                             %
%  The above copyright notice and this permission notice shall be included in %
%  all copies or substantial portions of ImageMagick.                         %
%                                                                             %
%  The software is provided "as is", without warranty of any kind, express or %
%  implied, including but not limited to the warranties of merchantability,   %
%  fitness for a particular purpose and noninfringement.  In no event shall   %
%  ImageMagick Studio be liable for any claim, damages or other liability,    %
%  whether in an action of contract, tort or otherwise, arising from, out of  %
%  or in connection with ImageMagick or the use or other dealings in          %
%  ImageMagick.                                                               %
%                                                                             %
%  Except as contained in this notice, the name of the ImageMagick Studio     %
%  shall not be used in advertising or otherwise to promote the sale, use or  %
%  other dealings in ImageMagick without prior written authorization from the %
%  ImageMagick Studio.                                                        %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
*/

/*
  Include declarations.
*/
#include "magick/studio.h"
#include "magick/blob.h"
#include "magick/error.h"
#include "magick/list.h"
#include "magick/magick.h"
#include "magick/static.h"
#include "magick/utility.h"

/*
  Bricks pattern.
*/
#define BricksImageExtent  41

static const unsigned char
  BricksImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x00, 0x01, 0x00,
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xFF,
    0xFF, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x01, 0x00, 0xFF, 0xFF,
  };

/*
  Checkerboard pattern.
*/
#define CheckerboardImageExtent  107

static const unsigned char
  CheckerboardImage[]=
  {
    0x47, 0x49, 0x46, 0x38, 0x37, 0x61, 0x1E, 0x00, 0x1E, 0x00, 0xF0, 0x01,
    0x00, 0x66, 0x66, 0x66, 0x99, 0x99, 0x99, 0x21, 0xF9, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x1E, 0x00,
    0x00, 0x02, 0x42, 0x8C, 0x8F, 0x09, 0xCB, 0xED, 0x09, 0x91, 0x9B, 0x2D,
    0x5A, 0x8A, 0x6D, 0xC4, 0x54, 0x43, 0x3E, 0x79, 0x0A, 0x58, 0x89, 0x07,
    0x59, 0x9A, 0x01, 0xCA, 0xA8, 0x06, 0xBB, 0xB8, 0x2B, 0x2C, 0xC3, 0x40,
    0x4D, 0xBB, 0x36, 0xCE, 0xF2, 0xA8, 0x6F, 0xFB, 0xA9, 0x82, 0xBA, 0xDD,
    0xD0, 0x68, 0x22, 0x1E, 0x73, 0x49, 0xA4, 0x48, 0xD9, 0x64, 0x3E, 0x9D,
    0x1E, 0xE8, 0x54, 0x5A, 0xA5, 0x6A, 0xAC, 0x9E, 0x02, 0x00, 0x3B,
  };

/*
  Circles pattern.
*/
#define CirclesImageExtent  41

static const unsigned char
  CirclesImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x07, 0xF0, 0x18,
    0x0C, 0x20, 0x02, 0x40, 0x01, 0x40, 0x01, 0x80, 0x00, 0x80, 0x00, 0x80,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x40,
    0x01, 0x20, 0x02, 0x18, 0x0C,
  };

/*
  CrossHatch pattern.
*/
#define CrossHatchImageExtent  11

static const unsigned char
  CrossHatchImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xFF, 0x11, 0x11, 0x11,
  };

/*
  CrossHatch30 pattern.
*/
#define CrossHatch30ImageExtent  11

static const unsigned char
  CrossHatch30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0x81, 0x66, 0x18, 0x66,
  };

/*
  CrossHatch45 pattern.
*/
#define CrossHatch45ImageExtent  15

static const unsigned char
  CrossHatch45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x88, 0x50, 0x20, 0x50, 0x88,
    0x05, 0x02, 0x05,
  };

/*
  FishScales pattern.
*/
#define FishScalesImageExtent  24

static const unsigned char
  FishScalesImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x38, 0x0A, 0x02, 0x40, 0x0C, 0x30,
    0x70, 0x0E, 0x80, 0x01, 0x40, 0x02, 0x30, 0x0C, 0x0E, 0x70, 0x01, 0x80,
  };

/*
  Gray100 pattern.
*/
#define Gray100ImageExtent  137

static const unsigned char
  Gray100Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
  };

/*
  Gray95 pattern.
*/
#define Gray95ImageExtent  137

static const unsigned char
  Gray95Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x10, 0x10, 0x10,
  };

/*
  Gray90 pattern.
*/
#define Gray90ImageExtent  137

static const unsigned char
  Gray90Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x08, 0x08, 0x08,
    0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x88, 0x80, 0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x88, 0x80, 0x88, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
    0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00,
  };

/*
  Gray85 pattern.
*/
#define Gray85ImageExtent  137

static const unsigned char
  Gray85Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x88, 0x8A, 0x88, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x88, 0x8A,
    0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x88, 0x8A, 0x88, 0x8A, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8,
    0xA8, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x8A, 0x88, 0x8A, 0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22,
  };

/*
  Gray80 pattern.
*/
#define Gray80ImageExtent  137

static const unsigned char
  Gray80Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x11, 0x51,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55,
    0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51, 0x51, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x51, 0x11, 0x51, 0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55,
    0x55, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51,
    0x51, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11,
  };

/*
  Gray75 pattern.
*/
#define Gray75ImageExtent  137

static const unsigned char
  Gray75Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00,
  };

/*
  Gray70 pattern.
*/
#define Gray70ImageExtent  137

static const unsigned char
  Gray70Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x01, 0x11,
    0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x01, 0x11, 0x01,
  };

/*
  Gray65 pattern.
*/
#define Gray65ImageExtent  137

static const unsigned char
  Gray65Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x10, 0x11,
    0x10, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x10, 0x10, 0x10, 0x10, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01,
    0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x10, 0x11, 0x10, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x10, 0x10, 0x10,
    0x10, 0xAA, 0xAA, 0xAA, 0xAA,
  };

/*
  Gray60 pattern.
*/
#define Gray60ImageExtent  137

static const unsigned char
  Gray60Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x45, 0x44, 0x45, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54,
    0x54, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x45, 0x44, 0x45, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54, 0x54, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x45, 0x44,
    0x45, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x54, 0x54, 0x54, 0x54, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x45, 0x44, 0x45, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54,
    0x54, 0xAA, 0xAA, 0xAA, 0xAA,
  };

/*
  Gray55 pattern.
*/
#define Gray55ImageExtent  137

static const unsigned char
  Gray55Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x2A, 0x2A, 0x2A,
    0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x22, 0x22, 0x22, 0x22, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x2A, 0x22, 0x2A, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x22, 0x22,
    0x22, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x2A, 0x2A, 0x2A, 0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x22, 0x22, 0x22, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x2A, 0x22,
    0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x22, 0x22, 0x22, 0x22,
  };

/*
  Gray50 pattern.
*/
#define Gray50ImageExtent  137

static const unsigned char
  Gray50Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55,
  };

/*
  Gray45 pattern.
*/
#define Gray45ImageExtent  137

static const unsigned char
  Gray45Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xBB, 0xBB, 0xBB,
    0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBB, 0xBB, 0xBB, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xAB, 0xBB,
    0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xBB, 0xBB, 0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBB, 0xBB,
    0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xAB, 0xBB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55,
  };

/*
  Gray40 pattern.
*/
#define Gray40ImageExtent  137

static const unsigned char
  Gray40Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBA, 0xBB,
    0xBA, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xBA, 0xBB, 0xBA, 0xBB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB,
    0xAB, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xBA, 0xBB, 0xBA, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xBA, 0xBB, 0xBA,
    0xBB, 0x55, 0x55, 0x55, 0x55,
  };

/*
  Gray35 pattern.
*/
#define Gray35ImageExtent  137

static const unsigned char
  Gray35Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F,
    0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0x77, 0xF7, 0x77, 0xF7, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD,
    0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F, 0x7F, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0xF7, 0xF7, 0xF7,
    0xF7, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0x7F, 0x7F, 0x7F, 0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD,
    0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x77, 0xF7, 0x77, 0xF7, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F,
    0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0xF7, 0xF7, 0xF7, 0xF7,
  };

/*
  Gray30 pattern.
*/
#define Gray30ImageExtent  137

static const unsigned char
  Gray30Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xFE, 0xEE,
    0xFE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFE, 0xFE, 0xFE, 0xFE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xFE, 0xEE, 0xFE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFE, 0xFE, 0xFE,
    0xFE, 0x55, 0x55, 0x55, 0x55,
  };

/*
  Gray25 pattern.
*/
#define Gray25ImageExtent  137

static const unsigned char
  Gray25Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55,
  };

/*
  Gray20 pattern.
*/
#define Gray20ImageExtent  137

static const unsigned char
  Gray20Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBB, 0xBA,
    0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB,
    0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xBA, 0xBB, 0xBA, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA,
    0xBA, 0xFF, 0xFF, 0xFF, 0xFF,
  };

/*
  Gray15 pattern.
*/
#define Gray15ImageExtent  137

static const unsigned char
  Gray15Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0xDD, 0xD5,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xD5, 0xDD, 0xD5, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D,
    0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xD5, 0xDD, 0xD5, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xD5, 0xDD,
    0xD5, 0xFF, 0xFF, 0xFF, 0xFF,
  };

/*
  Gray10 pattern.
*/
#define Gray10ImageExtent  137

static const unsigned char
  Gray10Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDD, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFD, 0xFD,
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFD, 0xFD, 0xFD,
  };

/*
  Gray5 pattern.
*/
#define Gray5ImageExtent  137

static const unsigned char
  Gray5Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF,
  };

/*
  Gray0 pattern.
*/
#define Gray0ImageExtent  137

static const unsigned char
  Gray0Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  };

/*
  Hexagons pattern.
*/
#define HexagonsImageExtent  81

static const unsigned char
  HexagonsImage[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x30, 0x20, 0x31, 0x38, 0x0A, 0x10, 0x01, 0x00,
    0x00, 0x10, 0x01, 0x00, 0x00, 0x20, 0x00, 0x80, 0x00, 0x20, 0x00, 0x80,
    0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x20,
    0x00, 0x80, 0x00, 0x20, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x80, 0x00, 0x20,
    0x00, 0x80, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40,
    0x00, 0x20, 0x00, 0x80, 0x00, 0x20, 0x00, 0x80, 0x00, 0x10, 0x01, 0x00,
    0x00, 0x10, 0x01, 0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00,
  };

/*
  Horizontal pattern.
*/
#define HorizontalImageExtent  11

static const unsigned char
  HorizontalImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xFF, 0x00, 0x00, 0x00,
  };

/*
  HorizontalSaw pattern.
*/
#define HorizontalSawImageExtent  24

static const unsigned char
  HorizontalSawImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x38, 0x0A, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x01, 0x01,
  };

/*
  HS_BDIAGONAL pattern (Windows GDI HS_BDIAGONAL)
*/
#define HS_BDIAGONALImageExtent  15

static const unsigned char
  HS_BDIAGONALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80,
  };

/*
  HS_CROSS pattern (Windows GDI HS_CROSS)
*/
#define HS_CROSSImageExtent  15

static const unsigned char
  HS_CROSSImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x10, 0x10, 0x10, 0xFF, 0x10,
    0x10, 0x10, 0x10,
  };

/*
  HS_DIAGCROSS pattern (Windows GDI HS_DIAGCROSS)
*/
#define HS_DIAGCROSSImageExtent  15

static const unsigned char
  HS_DIAGCROSSImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x81, 0x42, 0x24, 0x18, 0x18,
    0x24, 0x42, 0x81,
  };

/*
  HS_FDIAGONAL pattern (Windows GDI HS_FDIAGONAL)
*/
#define HS_FDIAGONALImageExtent  15

static const unsigned char
  HS_FDIAGONALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x40, 0x20, 0x10, 0x08,
    0x04, 0x02, 0x01,
  };

/*
  HS_HORIZONTAL pattern (Windows GDI HS_HORIZONTAL)
*/
#define HS_HORIZONTALImageExtent  15

static const unsigned char
  HS_HORIZONTALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x00, 0x00, 0x00, 0xFF, 0x00,
    0x00, 0x00, 0x00,
  };

/*
  HS_VERTICAL pattern (Windows GDI HS_VERTICAL)
*/
#define HS_VERTICALImageExtent  15

static const unsigned char
  HS_VERTICALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10,
  };

/*
  Left30 pattern.
*/
#define Left30ImageExtent  11

static const unsigned char
  Left30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xC0, 0x30, 0x0C, 0x03,
  };

/*
  Left45 pattern.
*/
#define Left45ImageExtent  15

static const unsigned char
  Left45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x40, 0x20, 0x10, 0x08,
    0x04, 0x02, 0x01,
  };

/*
  LeftShingle pattern.
*/
#define LeftShingleImageExtent  81

static const unsigned char
  LeftShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0xFF, 0xFF, 0xFF,
  };

/*
  Octagons image declaration.
*/
#define OctagonsImageExtent  41

static const unsigned char
  OctagonsImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x07, 0xF0, 0x08,
    0x08, 0x10, 0x04, 0x20, 0x02, 0x40, 0x01, 0x80, 0x00, 0x80, 0x00, 0x80,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x20,
    0x02, 0x10, 0x04, 0x08, 0x08,
  };

/*
  Right30 pattern.
*/
#define Right30ImageExtent  11

static const unsigned char
  Right30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0x03, 0x0C, 0x30, 0xC0,
  };

/*
  Right45 pattern.
*/
#define Right45ImageExtent  15

static const unsigned char
  Right45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80,
  };

/*
  RightShingle pattern.
*/
#define RightShingleImageExtent  81

static const unsigned char
  RightShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x00, 0x00, 0x08,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x08, 0x00,
    0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0xFF, 0xFF, 0xFF, 0x08, 0x00, 0x00,
    0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00,
    0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  };

/*
  SmallFishScales pattern.
*/
#define SmallFishScalesImageExtent  15

static const unsigned char
  SmallFishScalesImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x80, 0x41, 0x36, 0x08,
    0x08, 0x14, 0x63,
  };

/*
  Vertical pattern.
*/
#define VerticalImageExtent  15

static const unsigned char
  VerticalImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11,
  };

/*
  VerticalBricks pattern.
*/
#define VerticalBricksImageExtent  41

static const unsigned char
  VerticalBricksImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0xFF, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01,
  };

/*
  VerticalLeftShingle pattern.
*/
#define VerticalLeftShingleImageExtent  81

static const unsigned char
  VerticalLeftShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81,
    0x01, 0x01, 0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x01,
    0x01, 0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x01, 0x01,
    0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01,
  };

/*
  VerticalRightShingle pattern.
*/
#define VerticalRightShingleImageExtent  81

static const unsigned char
  VerticalRightShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01,
    0x01, 0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03,
    0x01, 0x01, 0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x01,
    0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01,
  };

/*
  VerticalSaw pattern.
*/
#define VerticalSawImageExtent  24

static const unsigned char
  VerticalSawImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x31, 0x36, 0x0A, 0x40, 0x20, 0x10, 0x08,
    0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40, 0x80,
  };

typedef struct _PatternInfo
{
  char
    name[MaxTextExtent],
    magick[MaxTextExtent];

  const void
    *blob;

  size_t
    extent;
} PatternInfo;

static const PatternInfo
  PatternImageList[] =
  {
    { "BRICKS", "PBM", BricksImage, BricksImageExtent },
    { "CHECKERBOARD", "GIF", CheckerboardImage, CheckerboardImageExtent },
    { "CIRCLES", "PBM", CirclesImage, CirclesImageExtent },
    { "CROSSHATCH", "PBM", CrossHatchImage, CrossHatchImageExtent },
    { "CROSSHATCH30", "PBM", CrossHatch30Image, CrossHatch30ImageExtent },
    { "CROSSHATCH45", "PBM", CrossHatch45Image, CrossHatch45ImageExtent },
    { "FISHSCALES", "PBM", FishScalesImage, FishScalesImageExtent },
    { "GRAY0", "PBM", Gray0Image, Gray0ImageExtent },
    { "GRAY5", "PBM", Gray5Image, Gray5ImageExtent },
    { "GRAY10", "PBM", Gray10Image, Gray10ImageExtent },
    { "GRAY15", "PBM", Gray15Image, Gray15ImageExtent },
    { "GRAY20", "PBM", Gray20Image, Gray20ImageExtent },
    { "GRAY25", "PBM", Gray25Image, Gray25ImageExtent },
    { "GRAY30", "PBM", Gray30Image, Gray30ImageExtent },
    { "GRAY35", "PBM", Gray35Image, Gray35ImageExtent },
    { "GRAY40", "PBM", Gray40Image, Gray40ImageExtent },
    { "GRAY45", "PBM", Gray45Image, Gray45ImageExtent },
    { "GRAY50", "PBM", Gray50Image, Gray50ImageExtent },
    { "GRAY55", "PBM", Gray55Image, Gray55ImageExtent },
    { "GRAY60", "PBM", Gray60Image, Gray60ImageExtent },
    { "GRAY65", "PBM", Gray65Image, Gray65ImageExtent },
    { "GRAY70", "PBM", Gray70Image, Gray70ImageExtent },
    { "GRAY75", "PBM", Gray75Image, Gray75ImageExtent },
    { "GRAY80", "PBM", Gray80Image, Gray80ImageExtent },
    { "GRAY85", "PBM", Gray85Image, Gray85ImageExtent },
    { "GRAY90", "PBM", Gray90Image, Gray90ImageExtent },
    { "GRAY95", "PBM", Gray95Image, Gray95ImageExtent },
    { "GRAY100", "PBM", Gray100Image, Gray100ImageExtent },
    { "HEXAGONS", "PBM", HexagonsImage, HexagonsImageExtent },
    { "HORIZONTAL", "PBM", HorizontalImage, HorizontalImageExtent },
    { "HORIZONTALSAW", "PBM", HorizontalSawImage, HorizontalSawImageExtent },
    { "HS_BDIAGONAL", "PBM", HS_BDIAGONALImage, HS_BDIAGONALImageExtent },
    { "HS_CROSS", "PBM", HS_CROSSImage, HS_CROSSImageExtent },
    { "HS_DIAGCROSS", "PBM", HS_DIAGCROSSImage, HS_DIAGCROSSImageExtent },
    { "HS_FDIAGONAL", "PBM", HS_FDIAGONALImage, HS_FDIAGONALImageExtent },
    { "HS_HORIZONTAL", "PBM", HS_HORIZONTALImage, HS_HORIZONTALImageExtent },
    { "HS_VERTICAL", "PBM", HS_VERTICALImage, HS_VERTICALImageExtent },
    { "LEFT30", "PBM", Left30Image, Left30ImageExtent },
    { "LEFT45", "PBM", Left45Image, Left45ImageExtent },
    { "LEFTSHINGLE", "PBM", LeftShingleImage, LeftShingleImageExtent },
    { "OCTAGONS", "PBM", OctagonsImage, OctagonsImageExtent },
    { "RIGHT30", "PBM", Right30Image, Right30ImageExtent },
    { "RIGHT45", "PBM", Right45Image, Right45ImageExtent },
    { "RIGHTSHINGLE", "PBM", RightShingleImage, RightShingleImageExtent },
    { "SMALLFISHSCALES", "PBM", SmallFishScalesImage,
      SmallFishScalesImageExtent },
    { "VERTICAL", "PBM", VerticalImage, VerticalImageExtent },
    { "VERTICALBRICKS", "PBM", VerticalBricksImage, VerticalBricksImageExtent },
    { "VERTICALLEFTSHINGLE", "PBM", VerticalLeftShingleImage,
      VerticalLeftShingleImageExtent },
    { "VERTICALRIGHTSHINGLE", "PBM", VerticalRightShingleImage,
      VerticalRightShingleImageExtent },
    { "VERTICALSAW", "PBM", VerticalSawImage, VerticalSawImageExtent },
    { "", "", (const void *) NULL, 0 }
  };

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   R e a d P A T T E R N I m a g e                                           %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  ReadPATTERNImage() reads a PATTERN image file and returns it.  It
%  allocates the memory necessary for the new Image structure and returns a
%  pointer to the new image.
%
%  The format of the ReadPATTERNImage method is:
%
%      Image *ReadPATTERNImage(const ImageInfo *image_info,
%        ExceptionInfo *exception)
%
%  A description of each parameter follows:
%
%    o image:  Method ReadPATTERNImage returns a pointer to the image after
%      reading.  A null image is returned if there is a memory shortage or
%      if the image cannot be read.
%
%    o image_info: The image info.
%
%    o exception: return any errors or warnings in this structure.
%
%
*/
static Image *ReadPATTERNImage(const ImageInfo *image_info,
  ExceptionInfo *exception)
{
  const void
    *blob;

  Image
    *image;

  ImageInfo
    *clone_info;

  register long
    i;

  size_t
    extent;

  clone_info=CloneImageInfo(image_info);
  image=(Image *) NULL;
  blob=(const void *) NULL;
  extent=0;
  for (i=0; PatternImageList[i].blob != (const void *) NULL; i++)
    if (LocaleCompare(clone_info->filename,PatternImageList[i].name) == 0)
      {
        (void) strcpy(clone_info->magick,PatternImageList[i].magick);
        blob=PatternImageList[i].blob;
        extent=PatternImageList[i].extent;
        break;
      }
  if (blob == (const void *) NULL)
    ThrowReaderException(OptionError,"UnrecognizedImageFormat",image)
  image=BlobToImage(clone_info,blob,extent,exception);
  if (image_info->size != (char *) NULL)
    {
      Image
        *pattern_image;

      /*
        Tile pattern across image canvas.
      */
      pattern_image=image;
      image=AllocateImage(clone_info);
      image->background_color=pattern_image->background_color;
      SetImage(image,OpaqueOpacity);
      TextureImage(image,pattern_image);
      DestroyImage(pattern_image);
    }
  DestroyImageInfo(clone_info);
  return(image);
}
/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   R e g i s t e r P A T T E R N I m a g e                                   %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Method RegisterPATTERNImage adds attributes for the PATTERN, GRANITE, NETSCAPE,
%  H, and ROSE image formats to the list of supported formats. The attributes
%  include the image format tag, a method to read and/or write the format,
%  whether the format supports the saving of more than one frame to the same
%  file or blob, whether the format supports native in-memory I/O, and a
%  brief description of the format.
%
%  The format of the RegisterPATTERNImage method is:
%
%      RegisterPATTERNImage(void)
%
*/
ModuleExport void RegisterPATTERNImage(void)
{
  MagickInfo
    *entry;

  entry=SetMagickInfo("PATTERN");
  entry->decoder=(DecoderHandler) ReadPATTERNImage;
  entry->adjoin=False;
  entry->description=AcquireString("Predefined pattern");
  entry->module=AcquireString("PATTERN");
  (void) RegisterMagickInfo(entry);
}

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   U n r e g i s t e r P A T T E R N I m a g e                               %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Method UnregisterPATTERNImage removes format registrations made by the
%  PATTERN module from the list of supported formats.
%
%  The format of the UnregisterPATTERNImage method is:
%
%      UnregisterPATTERNImage(void)
%
*/
ModuleExport void UnregisterPATTERNImage(void)
{
  (void) UnregisterMagickInfo("PATTERN");
}
