/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  $Id: droptionview.h,v 1.4 2002/03/11 10:57:16 goffioul Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#ifndef DROPTIONVIEW_H
#define DROPTIONVIEW_H

#include <qwidget.h>
#include <qgroupbox.h>
#include <qstringlist.h>

class QLineEdit;
class QSlider;
class QLabel;
class KListBox;
class QListBoxItem;
class QVButtonGroup;
class QWidgetStack;
class QListViewItem;
class DrBase;
class DriverItem;

class OptionBaseView : public QWidget
{
	Q_OBJECT
public:
	OptionBaseView(QWidget *parent = 0, const char *name = 0);
	virtual void setOption(DrBase*);
	virtual void setValue(const QString&);

signals:
	void valueChanged(const QString&);

protected:
	bool	blockSS;
};

class OptionNumericView : public OptionBaseView
{
	Q_OBJECT
public:
	OptionNumericView(QWidget *parent = 0, const char *name = 0);
	void setOption(DrBase *opt);
	void setValue(const QString& val);

protected slots:
	void slotSliderChanged(int);
	void slotEditChanged(const QString&);

private:
	QLineEdit	*m_edit;
	QSlider		*m_slider;
	QLabel		*m_minval, *m_maxval;
	bool		m_integer;
};

class OptionStringView : public OptionBaseView
{
public:
	OptionStringView(QWidget *parent = 0, const char *name = 0);
	void setOption(DrBase *opt);
	void setValue(const QString& val);

private:
	QLineEdit	*m_edit;
};

class OptionListView : public OptionBaseView
{
	Q_OBJECT
public:
	OptionListView(QWidget *parent = 0, const char *name = 0);
	void setOption(DrBase *opt);
	void setValue(const QString& val);

protected slots:
	void slotSelectionChanged();

private:
	KListBox	*m_list;
	QStringList	m_choices;
};

class OptionBooleanView : public OptionBaseView
{
	Q_OBJECT
public:
	OptionBooleanView(QWidget *parent = 0, const char *name = 0);
	void setOption(DrBase *opt);
	void setValue(const QString& val);

protected slots:
	void slotSelected(int);

private:
	QVButtonGroup	*m_group;
	QStringList	m_choices;
};

class DrOptionView : public QGroupBox
{
	Q_OBJECT
public:
	DrOptionView(QWidget *parent = 0, const char *name = 0);
	QSize sizeHint() const;
	void setAllowFixed(bool on) 	{ m_allowfixed = on; }

signals:
	void changed();

public slots:
	void slotValueChanged(const QString&);
	void slotItemSelected(QListViewItem*);

private:
	QWidgetStack	*m_stack;
	DriverItem	*m_item;
	bool		m_block;
	bool		m_allowfixed;
};

#endif
