/* A TEXT ZONE IS SOME WORDS WITH A SPECIAL STYLE (ITALIC, ...).
 * IT'S NOT USE FOR TITLE (BUT IN THE FUTURE IT WILL BE USED FOR)
 * OR FOR SPECIAL PARAG.
 */
/*
** Header file for inclusion with kword_xml2latex.c
**
** Copyright (C) 2000 Robert JACOLIN
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** To receive a copy of the GNU Library General Public License, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
*/

#ifndef __KWORD_PIXMAP_H__
#define __KWORD_PIXMAP_H__

#include "element.h"

/***********************************************************************/
/* Class: Pixmap                                                       */
/***********************************************************************/

/**
 * This class hold a pixmap. The pixmap must be converted in (e)ps. by using
 * the convert command.
 */
class Pixmap : public Element
{
	/* DATA MARKUP */
	int      _left,
		 _top,
		 _right,
		 _bottom;
	TAround  _runaround;
	double   _runaroundGap;
	TCreate  _autoCreate;
	TNFrame  _newFrameBehaviour;
	TSide   _sheetSide;
	bool    _keepAspectRatio;

	/* TEXT MARKUP */
	QString _key;
	QString _filename;
	QString _filenamePS;

	public:
		Pixmap();
		Pixmap(QString, QString);
		virtual ~Pixmap();

		/**
		 * Accessors
		 */
		TAround getRunAround  () const { return _runaround;         }
		double  getAroundGap  () const { return _runaroundGap;      }
		TCreate getAutoCreate () const { return _autoCreate;        }
		TNFrame getNewFrame   () const { return _newFrameBehaviour; }
		TSide   getSheetSide  () const { return _sheetSide;         }

		void getPixmap(QDomNode);
		QString getKey       () const { return _key;        }
		QString getFilenamePS() const { return _filenamePS; }

		/**
		 * Modifiers
		 */
		void setRunAround (const int a)    { _runaround = (TAround) a;  }
		void setAroundGap (const double r) { _runaroundGap = r;         }
		void setAutoCreate(const int a)    { _autoCreate = (TCreate) a; }
		void setNewFrame  (const int n)    { _newFrameBehaviour = (TNFrame) n; }
		void setSheetSide (const int s)    { _sheetSide = (TSide) s;    }
		void setKeepAspectRatio(const QString);

		void setKey        (QString k) { _key        = k; }
		void setFilename   (QString f) { _filename   = f; }
		void setFilenamePS (QString f) { _filenamePS = f; }

		/**
		 * Helpfull functions
		 */

		void analyse(const QDomNode);
		void convert();
		void generate(QTextStream&);
		/*void generate_format_begin(QTextStream &);
		void generate_format_end(QTextStream &);*/

	private:
		void analyseParamFrame(const QDomNode);
};

#endif /* __KWORD_PIXMAP_H__ */
